/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.geom.AffineTransform;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.PathOperator;
import org.freehep.postscript.TypeCheck;

class UStrokePath
extends PathOperator {
    private boolean done;
    private AffineTransform matrix;

    private UStrokePath(boolean d, AffineTransform m) {
        this.done = d;
        this.matrix = m;
    }

    public UStrokePath() {
    }

    @Override
    public boolean execute(OperandStack os) {
        if (!this.done) {
            if (!os.checkType(PSPackedArray.class)) {
                UStrokePath.error(os, new TypeCheck());
                return true;
            }
            AffineTransform matrix = null;
            PSPackedArray proc = os.popPackedArray();
            if (proc.size() == 6) {
                try {
                    matrix = new AffineTransform(proc.toDoubles());
                    if (!os.checkType(PSPackedArray.class)) {
                        UStrokePath.error(os, new TypeCheck());
                        return true;
                    }
                    proc = os.popPackedArray();
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
            }
            os.gstate().newPath();
            os.dictStack().push(os.dictStack().systemDictionary());
            PSPackedArray upath = (PSPackedArray)proc.copy();
            upath.setExecutable();
            os.execStack().pop();
            os.execStack().push(new UStrokePath(true, matrix));
            os.execStack().push(upath);
            return false;
        }
        os.dictStack().pop();
        if (this.matrix != null) {
            AffineTransform ctm = os.gstate().getTransform();
            os.gstate().transform(this.matrix);
            os.gstate().strokePath();
            os.gstate().setTransform(ctm);
        } else {
            os.gstate().strokePath();
        }
        os.grestore();
        return true;
    }
}

