/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.freehep.postscript.FileOperator;
import org.freehep.postscript.IOError;
import org.freehep.postscript.LoopingContext;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSInputFile;
import org.freehep.postscript.PSString;
import org.freehep.postscript.UndefinedFileName;

class Run
extends FileOperator
implements LoopingContext {
    Run() {
        this.operandTypes = new Class[]{PSString.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        String name = os.popString().getValue();
        try {
            PSInputFile file = new PSInputFile(name, os.getDSC());
            file.setExecutable();
            os.execStack().pop();
            os.execStack().push(file);
            return false;
        }
        catch (FileNotFoundException e) {
            Run.error(os, new UndefinedFileName());
        }
        catch (IOException e) {
            Run.error(os, new IOError());
        }
        return true;
    }
}

