/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSInteger;
import org.freehep.postscript.RangeCheck;
import org.freehep.postscript.StackOperator;
import org.freehep.postscript.StackUnderflow;

class Roll
extends StackOperator {
    Roll() {
        this.operandTypes = new Class[]{PSInteger.class, PSInteger.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        PSInteger j = os.popInteger();
        PSInteger n = os.popInteger();
        if (n.getValue() == 0) {
            return true;
        }
        if (n.getValue() < 0 || Math.abs(j.getValue()) > n.getValue()) {
            Roll.error(os, new RangeCheck());
        } else if (n.getValue() > os.size()) {
            Roll.error(os, new StackUnderflow());
        } else {
            os.roll(n.getValue(), j.getValue());
        }
        return true;
    }
}

