/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import org.freehep.postscript.LoopingContext;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.PathOperator;
import org.freehep.postscript.RangeCheck;
import org.freehep.postscript.TypeCheck;

class PathForAll
extends PathOperator
implements LoopingContext {
    private Shape path = null;
    private PSPackedArray moveProc;
    private PSPackedArray lineProc;
    private PSPackedArray curveProc;
    private PSPackedArray closeProc;
    private PathIterator iterator;
    private double[] coord;

    private PathForAll(Shape shape, PSPackedArray move, PSPackedArray line, PSPackedArray curve, PSPackedArray close) {
        this.path = shape;
        this.moveProc = move;
        this.lineProc = line;
        this.curveProc = curve;
        this.closeProc = close;
        this.iterator = this.path.getPathIterator(new AffineTransform());
        this.coord = new double[6];
    }

    public PathForAll() {
    }

    @Override
    public boolean execute(OperandStack os) {
        if (this.path == null) {
            if (!os.checkType(PSPackedArray.class, PSPackedArray.class, PSPackedArray.class, PSPackedArray.class)) {
                PathForAll.error(os, new TypeCheck());
                return true;
            }
            PSPackedArray close = os.popPackedArray();
            PSPackedArray curve = os.popPackedArray();
            PSPackedArray line = os.popPackedArray();
            PSPackedArray move = os.popPackedArray();
            Shape shape = (Shape)os.gstate().path().clone();
            os.execStack().pop();
            os.execStack().push(new PathForAll(shape, move, line, curve, close));
            return false;
        }
        if (this.iterator.isDone()) {
            return true;
        }
        switch (this.iterator.currentSegment(this.coord)) {
            case 0: {
                os.push(this.coord[0]);
                os.push(this.coord[1]);
                os.execStack().push(this.moveProc);
                break;
            }
            case 1: {
                os.push(this.coord[0]);
                os.push(this.coord[1]);
                os.execStack().push(this.lineProc);
                break;
            }
            case 3: {
                os.push(this.coord[0]);
                os.push(this.coord[1]);
                os.push(this.coord[2]);
                os.push(this.coord[3]);
                os.push(this.coord[4]);
                os.push(this.coord[5]);
                os.execStack().push(this.curveProc);
                break;
            }
            case 4: {
                os.execStack().push(this.closeProc);
                break;
            }
            default: {
                PathForAll.error(os, new RangeCheck());
                return true;
            }
        }
        this.iterator.next();
        return false;
    }
}

