/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSSimple;
import org.freehep.postscript.PSString;
import org.freehep.postscript.Undefined;

public class PSName
extends PSSimple {
    private String value;

    public PSName(String name) {
        this(name, false);
    }

    public PSName(String name, boolean literal) {
        super("name", literal);
        this.value = name;
    }

    @Override
    public boolean execute(OperandStack os) {
        if (this.isLiteral()) {
            os.push(this);
            return true;
        }
        if (this.value.charAt(0) == '\u001b') {
            return true;
        }
        PSObject obj = os.dictStack().lookup(this);
        if (obj == null) {
            PSName.error(os, new Undefined());
        }
        os.execStack().pop();
        os.execStack().push(obj);
        return false;
    }

    public int size() {
        return this.value.length();
    }

    @Override
    public String getType() {
        return "nametype";
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public Object clone() {
        return new PSName(this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof PSName) {
            return this.getValue().equals(((PSName)o).getValue());
        }
        if (o instanceof PSString) {
            return this.getValue().equals(((PSString)o).getValue());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String cvs() {
        return this.value;
    }

    @Override
    public String toString() {
        return (this.isLiteral() ? "/" : "") + this.value;
    }
}

