/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.freehep.postscript.BreakException;
import org.freehep.postscript.DebuggerListener;
import org.freehep.postscript.DictionaryStack;
import org.freehep.postscript.ExecutableStack;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PostScriptStack;

public class PSDebugger
extends JPanel {
    private static final int NCOLS = 3;
    private static final int NROWS = 10;
    private List listeners = new ArrayList();
    private JButton[][] b = new JButton[3][10];
    private JPanel stackPanel;
    private JPanel buttonPanel;

    public PSDebugger() {
        this.setLayout(new BorderLayout(10, 10));
        this.stackPanel = new JPanel();
        this.stackPanel.setLayout(new GridLayout(10, 3));
        for (int row = 0; row < 10; ++row) {
            for (int col = 0; col < 3; ++col) {
                this.b[col][row] = new JButton(col + ":" + row);
                this.stackPanel.add(this.b[col][row]);
            }
        }
        this.b[0][0].setText("********************************");
        this.b[0][0].setEnabled(false);
        this.b[1][0].setText("********************************");
        this.b[1][0].setEnabled(false);
        this.b[2][0].setText("********************************");
        this.b[2][0].setEnabled(false);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(1, 2));
        JButton step = new JButton("Step");
        this.buttonPanel.add(step);
        step.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Iterator i = PSDebugger.this.listeners.iterator();
                while (i.hasNext()) {
                    try {
                        ((DebuggerListener)i.next()).step();
                    }
                    catch (BreakException be) {
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
        });
        JButton go = new JButton("Go");
        this.buttonPanel.add(go);
        go.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Iterator i = PSDebugger.this.listeners.iterator();
                while (i.hasNext()) {
                    try {
                        ((DebuggerListener)i.next()).go();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
            }
        });
        this.add((Component)this.stackPanel, "Center");
        this.add((Component)this.buttonPanel, "South");
    }

    public void addDebuggerListener(DebuggerListener listener) {
        this.listeners.add(listener);
    }

    public void removeDebuggerListener(DebuggerListener listener) {
        this.listeners.remove(listener);
    }

    public void showInFrame() {
        JFrame frame = new JFrame("FreeHEP PostScript Debugger");
        frame.getContentPane().add(this);
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public void update(DictionaryStack dictStack, ExecutableStack execStack, OperandStack operandStack) {
        this.update(dictStack, 0);
        this.update(execStack, 1);
        this.update(operandStack, 2);
    }

    public void update(PostScriptStack ps, int col) {
        this.b[col][0].setText(ps.toString() + "(" + ps.size() + ")" + "     ");
        for (int i = 1; i < 10; ++i) {
            if (i - 1 < ps.size()) {
                this.b[col][i].setText(ps.elementAt(ps.size() - i).toString());
                continue;
            }
            this.b[col][i].setText("--");
        }
    }
}

