/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.freehep.postscript.PSDictionary;
import org.freehep.postscript.PSGlyph;
import org.freehep.postscript.PSInteger;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.PSString;
import org.freehep.postscript.PSType1Glyph;
import org.freehep.util.io.EEXECDecryption;

public class PSCharStringDecoder {
    protected int currentX;
    protected int currentY;
    private InputStream decryption;
    private List charProc;
    protected int sbX;
    protected int sbY;
    protected int widthX;
    protected int widthY;
    private PSPackedArray array;
    private PSDictionary dict;

    public PSCharStringDecoder(PSDictionary dict) {
        this.dict = dict;
    }

    public PSGlyph decode(PSString charString) throws IOException {
        this.decryption = new EEXECDecryption(charString.getInputStream(), 4330, 4);
        this.currentY = 0;
        this.currentX = 0;
        this.charProc = new LinkedList();
        boolean end = false;
        do {
            int byte1;
            if ((byte1 = this.decryption.read()) < 0) {
                end = true;
                continue;
            }
            if (byte1 >= 0 && byte1 <= 31) {
                if (byte1 != 12) {
                    switch (byte1) {
                        case 14: {
                            this.addCommand("eofill");
                            break;
                        }
                        case 13: {
                            this.hsbw();
                            break;
                        }
                        case 9: {
                            this.addCommand("closepath");
                            break;
                        }
                        case 6: {
                            this.addCommand("hlineto");
                            break;
                        }
                        case 22: {
                            this.addCommand("hmoveto");
                            break;
                        }
                        case 31: {
                            this.addCommand("hcurveto");
                            break;
                        }
                        case 5: {
                            this.addCommand("rlineto");
                            break;
                        }
                        case 21: {
                            this.addCommand("rmoveto");
                            break;
                        }
                        case 8: {
                            this.addCommand("rrcurveto");
                            break;
                        }
                        case 30: {
                            this.addCommand("vhcurveto");
                            break;
                        }
                        case 7: {
                            this.addCommand("vlineto");
                            break;
                        }
                        case 4: {
                            this.addCommand("vmoveto");
                            break;
                        }
                        case 1: {
                            this.ignore(2);
                            break;
                        }
                        case 3: {
                            this.ignore(2);
                            break;
                        }
                        default: {
                            System.err.println("Command " + byte1 + " not implemented");
                            break;
                        }
                    }
                    continue;
                }
                int byte2 = this.decryption.read();
                switch (byte2) {
                    case 7: {
                        this.sbw();
                        break;
                    }
                    case 0: {
                        this.ignore(2);
                        break;
                    }
                    case 2: {
                        this.ignore(6);
                        break;
                    }
                    case 1: {
                        this.ignore(6);
                        break;
                    }
                    case 33: {
                        this.addCommand("setcurrentpoint");
                        break;
                    }
                    default: {
                        System.err.println("Command 12 " + byte2 + " not implemented");
                        break;
                    }
                }
                continue;
            }
            int value = this.readNumber(byte1);
            this.addNumber(value);
        } while (!end);
        PSObject[] obj = new PSObject[this.charProc.size()];
        Iterator i = this.charProc.iterator();
        int j = 0;
        while (i.hasNext()) {
            obj[j++] = (PSObject)i.next();
        }
        this.array = new PSPackedArray(obj);
        this.array.setExecutable();
        return new PSType1Glyph(this.array, this.widthX, this.sbX);
    }

    private int readNumber(int v) throws IOException {
        int value = 0;
        if (v >= 32 && v <= 246) {
            value = v - 139;
        } else if (v >= 247 && v <= 250) {
            int w = this.decryption.read();
            value = (v - 247) * 256 + w + 108;
        } else if (v >= 251 && v <= 254) {
            int w = this.decryption.read();
            value = -((v - 251) * 256) - w - 108;
        } else {
            value = this.decryption.read() << 24 + this.decryption.read() << 16 + this.decryption.read() << 8 + this.decryption.read() << 0;
        }
        return value;
    }

    private void addCommand(String name) {
        this.charProc.add(this.dict.get(name));
    }

    private void addNumber(int i) {
        this.charProc.add(new PSInteger(i));
    }

    private void ignore(int n) {
        for (int i = 0; i < n; ++i) {
            this.charProc.remove(this.charProc.size() - 1);
        }
    }

    private int pop() {
        return ((PSInteger)this.charProc.remove(this.charProc.size() - 1)).getValue();
    }

    private void hsbw() {
        this.widthY = 0;
        this.widthX = this.pop();
        this.sbY = 0;
        this.sbX = this.pop();
        this.addInitialPoint();
    }

    private void sbw() {
        this.widthY = this.pop();
        this.widthX = this.pop();
        this.sbY = this.pop();
        this.sbX = this.pop();
        this.addInitialPoint();
    }

    private void addInitialPoint() {
        if (this.sbX == 0) {
            return;
        }
        this.charProc.add(0, this.dict.get("moveto"));
        this.charProc.add(0, new PSInteger(0));
        this.charProc.add(0, new PSInteger(this.sbX));
    }
}

