/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.freehep.postscript.FixedTexturePaint;
import org.freehep.postscript.FormOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSDictionary;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.PSPaint;
import org.freehep.postscript.RangeCheck;
import org.freehep.postscript.TypeCheck;

class MakePattern
extends FormOperator {
    private PSDictionary pattern;
    private Paint paint;

    private MakePattern(PSDictionary d, Paint p) {
        this.pattern = d;
        this.paint = p;
    }

    public MakePattern() {
    }

    @Override
    public boolean execute(OperandStack os) {
        if (this.pattern == null) {
            if (!os.checkType(PSDictionary.class, PSPackedArray.class)) {
                MakePattern.error(os, new TypeCheck());
                return true;
            }
            AffineTransform m = new AffineTransform(os.popPackedArray().toDoubles());
            PSDictionary d = os.popDictionary();
            int type = d.getInteger("PatternType");
            switch (type) {
                case 1: {
                    PSPackedArray proc = (PSPackedArray)d.getPackedArray("PaintProc").copy();
                    double[] bbox = d.getPackedArray("BBox").toDoubles();
                    double xStep = d.getNumber("XStep").getDouble();
                    double yStep = d.getNumber("YStep").getDouble();
                    int paintType = d.getInteger("PaintType");
                    int tilingType = d.getInteger("TilingType");
                    os.push(d);
                    os.gsave();
                    AffineTransform inverse = new AffineTransform();
                    try {
                        inverse = m.createInverse();
                    }
                    catch (NoninvertibleTransformException e) {
                        System.err.println("Internal MakePattern Error");
                    }
                    Point2D bb = inverse.deltaTransform(new Point2D.Double(1.0, 1.0), null);
                    double w = bbox[2] - bbox[0] + bb.getX();
                    double h = bbox[3] - bbox[1] + bb.getY();
                    Point2D biSize = m.deltaTransform(new Point2D.Double(xStep, yStep), null);
                    int biWidth = (int)biSize.getX();
                    int biHeight = (int)biSize.getY();
                    BufferedImage bi = os.gstate().convertToImage(biWidth, biHeight);
                    AffineTransform ctm = os.gstate().getTransform();
                    os.gstate().setTransform(m);
                    os.gstate().translate(-bbox[0], -bbox[1]);
                    os.gstate().newPath();
                    os.gstate().clip(new Rectangle2D.Double(bbox[0], bbox[1], w, h));
                    Point2D offset = inverse.transform(new Point2D.Double(bbox[0], bbox[1]), null);
                    Rectangle2D.Double box = new Rectangle2D.Double(offset.getX(), offset.getY(), biWidth, biHeight);
                    FixedTexturePaint p = new FixedTexturePaint(os, ctm, bi, box);
                    os.execStack().pop();
                    os.execStack().push(new MakePattern(d, p));
                    os.execStack().push(proc);
                    switch (paintType) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            os.gstate().setColorSpace("DeviceRGB");
                            os.gstate().setColor(new float[]{1.0f, 0.0f, 0.0f});
                            break;
                        }
                        default: {
                            MakePattern.error(os, new RangeCheck());
                            return true;
                        }
                    }
                    return false;
                }
            }
            MakePattern.error(os, new RangeCheck());
            return true;
        }
        os.grestore();
        this.pattern.put("Implementation", (PSObject)new PSPaint(this.paint));
        os.push(this.pattern);
        return true;
    }
}

