/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.ArithmeticOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSNumber;
import org.freehep.postscript.RangeCheck;

class Log
extends ArithmeticOperator {
    Log() {
        this.operandTypes = new Class[]{PSNumber.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        PSNumber num = os.popNumber();
        if (num.getDouble() <= 0.0) {
            Log.error(os, new RangeCheck());
        } else {
            double r = Math.log(num.getDouble()) / Math.log(10.0);
            os.push(r);
        }
        return true;
    }
}

