/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import org.freehep.postscript.MatrixOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSNumber;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.TypeCheck;
import org.freehep.postscript.UndefinedResult;

class IDTransform
extends MatrixOperator {
    IDTransform() {
        this.operandTypes = new Class[]{PSObject.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        AffineTransform transform;
        double dx;
        double dy;
        if (os.checkType(PSNumber.class, PSNumber.class)) {
            dy = os.popNumber().getDouble();
            dx = os.popNumber().getDouble();
            transform = os.gstate().getTransform();
        } else if (os.checkType(PSNumber.class, PSNumber.class, PSPackedArray.class)) {
            double[] m = os.popPackedArray().toDoubles();
            dy = os.popNumber().getDouble();
            dx = os.popNumber().getDouble();
            transform = new AffineTransform(m);
        } else {
            IDTransform.error(os, new TypeCheck());
            return true;
        }
        try {
            AffineTransform inverse = transform.createInverse();
            Point2D d = inverse.deltaTransform(new Point2D.Double(dx, dy), null);
            os.push(d.getX());
            os.push(d.getY());
        }
        catch (NoninvertibleTransformException e) {
            IDTransform.error(os, new UndefinedResult());
        }
        return true;
    }
}

