/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.freehep.postscript.FileOperator;
import org.freehep.postscript.InvalidFileAccess;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSInputFile;
import org.freehep.postscript.PSOutputFile;
import org.freehep.postscript.PSRandomAccessFile;
import org.freehep.postscript.PSString;
import org.freehep.postscript.Undefined;
import org.freehep.postscript.UndefinedFileName;

class FileFile
extends FileOperator {
    FileFile() {
        this.operandTypes = new Class[]{PSString.class, PSString.class};
    }

    @Override
    public String getName() {
        return "file";
    }

    @Override
    public boolean execute(OperandStack os) {
        String access = os.popString().getValue();
        String filename = os.popString().getValue();
        try {
            if (filename.equals("%stdin")) {
                os.push(new PSInputFile(System.in, os.getDSC()));
            } else if (filename.equals("%stdout")) {
                os.push(new PSOutputFile(System.out));
            } else if (filename.equals("%stderr")) {
                os.push(new PSOutputFile(System.err));
            } else if (filename.equals("%lineedit") || filename.equals("%statementedit")) {
                System.err.println("%lineedit and %statementedit not supported.");
                FileFile.error(os, new Undefined());
            } else {
                boolean append;
                boolean rw = access.length() > 1 && access.charAt(1) == '+';
                boolean write = access.length() > 0 && access.charAt(0) == 'w';
                boolean bl = append = access.length() > 0 && access.charAt(0) == 'a';
                if (rw) {
                    os.push(new PSRandomAccessFile(filename, write, append, os.isSecure()));
                } else if (write || append) {
                    os.push(new PSOutputFile(filename, append, os.isSecure()));
                } else {
                    os.push(new PSInputFile(filename, os.getDSC()));
                }
            }
        }
        catch (FileNotFoundException e) {
            FileFile.error(os, new UndefinedFileName());
        }
        catch (IOException e) {
            FileFile.error(os, new InvalidFileAccess());
        }
        return true;
    }
}

