/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.ArithmeticOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSNumber;
import org.freehep.postscript.UndefinedResult;

class Exp
extends ArithmeticOperator {
    Exp() {
        this.operandTypes = new Class[]{PSNumber.class, PSNumber.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        PSNumber exponent = os.popNumber();
        PSNumber base = os.popNumber();
        if (exponent.getDouble() % 1.0 != 0.0 && base.getDouble() < 0.0) {
            Exp.error(os, new UndefinedResult());
        } else {
            double r = Math.pow(base.getDouble(), exponent.getDouble());
            os.push(r);
        }
        return true;
    }
}

