/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.freehep.postscript.DSCEvent;
import org.freehep.postscript.DSCEventListener;
import org.freehep.postscript.OperandStack;

public class DSC {
    private static final String[] mode = new String[]{"diablo630", "fx100", "lj2000", "hpgl", "impress", "hplj", "ti855"};
    private static final String[] orientation = new String[]{"Portrait", "Landscape"};
    private static final String[] cmyk = new String[]{"Cyan", "Magenta", "Yellow", "Black"};
    private static final Object[] keyArgs = new Object[]{"PS-Adobe-3.0", TextLine.class, "PS-Adobe-2.1", NoArgs.class, "PS-Adobe-2.0", NoArgs.class, "PS-Adobe-1.0", NoArgs.class, "BoundingBox:", Rectangle.class, "Copyright:", TextLine.class, "Creator:", TextLine.class, "CreationDate:", TextLine.class, "DocumentData:", new String[]{"Clean7Bit", "Clean8Bit", "Binary"}, "Emulation:", mode, "EndComments", NoArgs.class, "Extensions:", new String[]{"DPS", "CMYK", "Composite", "FileSystem"}, "For:", TextLine.class, "LanguageLevel:", UInt.class, "Orientation:", orientation, "Pages:", UInt.class, "PageOrder:", new String[]{"Ascend", "Descend", "Special"}, "Routing:", TextLine.class, "Title:", TextLine.class, "Version:", Version.class, "BeginBinary:", UInt.class, "EndBinary", NoArgs.class, "BeginData:", Unparsed.class, "EndData", NoArgs.class, "BeginDefaults", NoArgs.class, "EndDefaults", NoArgs.class, "BeginEmulation:", mode, "EndEmulation", NoArgs.class, "BeginPreview:", Unparsed.class, "EndPreview", NoArgs.class, "BeginProlog", NoArgs.class, "EndProlog", NoArgs.class, "BeginSetup", NoArgs.class, "EndSetup", NoArgs.class, "BeginObject:", Unparsed.class, "EndObject", NoArgs.class, "BeginPageSetup", NoArgs.class, "EndPageSetup", NoArgs.class, "Page:", Page.class, "PageBoundingBox:", Rectangle.class, "PageOrientation:", orientation, "PageTrailer", NoArgs.class, "Trailer", NoArgs.class, "EOF", NoArgs.class, "DocumentMedia:", Unparsed.class, "DocumentNeededResources:", Unparsed.class, "DocumentSuppliedResources:", Unparsed.class, "DocumentPrinterRequired:", Unparsed.class, "DocumentNeededFiles:", Unparsed.class, "DocumentSuppliedFiles:", Unparsed.class, "DocumentFonts:", Unparsed.class, "DocumentNeededFonts:", Unparsed.class, "DocumentSuppliedFonts:", Unparsed.class, "DocumentProcSets:", Unparsed.class, "DocumentNeededProcSets:", Unparsed.class, "DocumentSuppliedProcSets:", Unparsed.class, "OperatorIntervention:", Unparsed.class, "OperatorMessage:", Unparsed.class, "ProofMode:", new String[]{"TrustMe", "Substitute", "NotifyMe"}, "Requirements:", Unparsed.class, "VMlocation:", new String[]{"global", "local"}, "VMusage:", Unparsed.class, "BeginDocument:", Unparsed.class, "EndDocument", NoArgs.class, "IncludeDocument:", Unparsed.class, "BeginFeature:", Unparsed.class, "EndFeature", NoArgs.class, "IncludeFeature:", Unparsed.class, "BeginFile:", Unparsed.class, "EndFile", NoArgs.class, "IncludeFile:", Unparsed.class, "BeginFont:", Unparsed.class, "EndFont", NoArgs.class, "IncludeFont:", Unparsed.class, "BeginProcSet:", Unparsed.class, "EndProcSet", NoArgs.class, "IncludeProcSet:", Unparsed.class, "BeginResource:", Unparsed.class, "EndResource", NoArgs.class, "IncludeResource:", Unparsed.class, "PageFonts:", Unparsed.class, "PageFiles:", Unparsed.class, "PageMedia:", Unparsed.class, "PageRequirements:", Unparsed.class, "PageResources:", Unparsed.class, "CMYKCustomColor:", Unparsed.class, "DocumentCustomColors:", Unparsed.class, "DocumentProcessColors:", Unparsed.class, "RGBCustomColor:", Unparsed.class, "BeginCustomColor:", Unparsed.class, "EndCustomColor", NoArgs.class, "BeginProcessColor:", cmyk, "EndProcesColor", NoArgs.class, "PageCustomColors:", Unparsed.class, "PageProcessColors:", Unparsed.class, "?BeginFeatureQuery:", Unparsed.class, "?EndFeatureQuery:", Unparsed.class, "?BeginFileQuery:", Unparsed.class, "?EndFileQuery:", Unparsed.class, "?BeginFontListQuery", NoArgs.class, "?EndFontListQuery:", Unparsed.class, "?BeginFontQuery:", Unparsed.class, "?EndFontQuery:", Unparsed.class, "?BeginPrinterQuery", NoArgs.class, "?EndPrinterQuery:", Unparsed.class, "?BeginQuery:", Unparsed.class, "?EndQuery:", Unparsed.class, "?BeginQuery:", Unparsed.class, "?EndQuery:", Unparsed.class, "?BeginQuery:", Unparsed.class, "?EndQuery:", Unparsed.class, "?BeginResourceListQuery:", new String[]{"font", "file", "procset", "pattern", "form", "encoding"}, "?EndResourceListQuery:", Unparsed.class, "?BeginResourceQuery:", Unparsed.class, "?EndResourceQuery:", Unparsed.class, "?BeginVMStatus", NoArgs.class, "?EndVMStatus:", Unparsed.class, "?BeginExitServer:", Unparsed.class, "?EndExitServer", NoArgs.class};
    private Collection listeners = new ArrayList();
    private Map parseTable = new HashMap();
    private Map dscTable = new HashMap();

    public DSC() {
        for (int i = 0; i < keyArgs.length; i += 2) {
            String token = (String)keyArgs[i];
            try {
                Object obj = keyArgs[i + 1];
                if (obj instanceof Class) {
                    obj = ((Class)obj).newInstance();
                } else if (obj instanceof String[]) {
                    obj = new Enumeration((String[])obj);
                }
                this.addDSCComment(token, obj);
                continue;
            }
            catch (InstantiationException ie) {
                System.err.println("DSC: could not instantiate class: '" + token);
                continue;
            }
            catch (IllegalAccessException ie) {
                System.err.println("DSC: no access to class: '" + token);
            }
        }
    }

    public Object addDSCComment(String comment, Object parse) {
        Object obj = this.parseTable.get(comment);
        this.parseTable.put(comment, parse);
        return obj;
    }

    public void addDSCEventListener(DSCEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeDSCEventListener(DSCEventListener listener) {
        this.listeners.remove(listener);
    }

    public boolean parse(String line, OperandStack os) {
        int state;
        String[] tokens = line.split("[ \t]", 2);
        String key = tokens[0];
        String params = "";
        if (tokens.length == 1) {
            tokens = line.split(":", 2);
            if (tokens.length == 2) {
                key = tokens[0] + ":";
                params = tokens[1];
            }
        } else {
            params = tokens[1];
        }
        Arguments args = (Arguments)this.parseTable.get(key);
        if (params.startsWith("(atend)")) {
            this.dscTable.put(key, new Boolean(true));
            state = args != null ? DSCEvent.PARSED : DSCEvent.UNPARSED;
        } else if (args != null) {
            Object parsed = args.parse(key, params, os);
            if (parsed != null) {
                this.dscTable.put(key, parsed);
                state = DSCEvent.PARSED;
            } else {
                state = DSCEvent.ERROR;
            }
        } else {
            this.dscTable.put(key, params);
            state = DSCEvent.UNPARSED;
        }
        for (DSCEventListener listener : this.listeners) {
            listener.dscCommentFound(new DSCEvent(this, key, this.dscTable.get(key), state));
        }
        return state != DSCEvent.ERROR;
    }

    public Object get(String key) {
        return this.dscTable.get(key);
    }

    public static String text(String s) {
        if (s.startsWith("(") && s.endsWith(")")) {
            s = s.substring(1, s.length() - 2);
        }
        return s;
    }

    public static class Page
    implements Arguments {
        private String label;
        private long number;

        public Page() {
        }

        public Page(String l, long n) {
            this.label = l;
            this.number = n;
        }

        public String getLabel() {
            return this.label;
        }

        public long getNumber() {
            return this.number;
        }

        @Override
        public Object parse(String key, String params, OperandStack os) {
            try {
                String[] tokens = params.split("[ \t]", 2);
                if (tokens.length != 2) {
                    return null;
                }
                long n = Long.parseLong(tokens[1]);
                return new Page(DSC.text(tokens[0]), n);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public String toString() {
            return this.label + " " + this.number;
        }
    }

    public static class Version
    implements Arguments {
        private double version;
        private long revision;

        public Version() {
        }

        public Version(double v, long r) {
            this.version = v;
            this.revision = r;
        }

        public double getVersion() {
            return this.version;
        }

        public long getRevision() {
            return this.revision;
        }

        @Override
        public Object parse(String key, String params, OperandStack os) {
            try {
                String[] tokens = params.split("[ \t]", 2);
                if (tokens.length != 2) {
                    return null;
                }
                double v = Double.parseDouble(tokens[0]);
                long r = Long.parseLong(tokens[1]);
                return new Version(v, r);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        public String toString() {
            return "v" + this.version + "r" + this.revision;
        }
    }

    public static class Unparsed
    implements Arguments {
        @Override
        public Object parse(String key, String params, OperandStack os) {
            return params;
        }
    }

    public static class Enumeration
    implements Arguments {
        private String[] enumeration;

        public Enumeration(String[] enumeration) {
            this.enumeration = enumeration;
        }

        @Override
        public Object parse(String key, String params, OperandStack os) {
            String[] tokens = params.split("[ \t]", 2);
            for (int i = 0; i < this.enumeration.length; ++i) {
                if (!this.enumeration[i].equals(tokens[0])) continue;
                return tokens[0];
            }
            return null;
        }
    }

    public static class UInt
    implements Arguments {
        @Override
        public Object parse(String key, String params, OperandStack os) {
            try {
                String[] tokens = params.split("[ \t]", 2);
                return Long.valueOf(tokens[0]);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public static class Rectangle
    implements Arguments {
        @Override
        public Object parse(String key, String params, OperandStack os) {
            try {
                String[] tokens = params.split("[ \t]", 4);
                if (tokens.length != 4) {
                    return null;
                }
                int[] p = new int[4];
                for (int i = 0; i < tokens.length; ++i) {
                    p[i] = Integer.parseInt(tokens[i]);
                }
                return new java.awt.Rectangle(p[0], p[1], p[2] - p[0], p[3] - p[1]);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    }

    public static class TextLine
    implements Arguments {
        @Override
        public Object parse(String key, String params, OperandStack os) {
            return DSC.text(params);
        }
    }

    public static class NoArgs
    implements Arguments {
        @Override
        public Object parse(String key, String params, OperandStack os) {
            return new Boolean(true);
        }
    }

    public static interface Arguments {
        public Object parse(String var1, String var2, OperandStack var3);
    }
}

