/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.ConversionOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSInteger;
import org.freehep.postscript.PSNumber;
import org.freehep.postscript.PSString;
import org.freehep.postscript.RangeCheck;
import org.freehep.postscript.RangeException;

class CvRS
extends ConversionOperator {
    CvRS() {
        this.operandTypes = new Class[]{PSNumber.class, PSInteger.class, PSString.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        try {
            PSString s = os.popString();
            PSInteger r = os.popInteger();
            PSNumber n = os.popNumber();
            byte[] b = r.getValue() == 10 ? n.cvs().getBytes() : Integer.toString(n.getInt(), r.getValue()).getBytes();
            if (b.length > s.size()) {
                CvRS.error(os, new RangeCheck());
            } else {
                for (int i = 0; i < b.length; ++i) {
                    s.set(i, b[i]);
                }
                os.push(s.subString(0, b.length));
            }
        }
        catch (RangeException e) {
            CvRS.error(os, new RangeCheck());
        }
        return true;
    }
}

