/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.ConversionOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSNumber;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSString;
import org.freehep.postscript.PSUtils;
import org.freehep.postscript.RangeCheck;
import org.freehep.postscript.RangeException;
import org.freehep.postscript.TypeCheck;
import org.freehep.postscript.UndefinedResult;

class CvI
extends ConversionOperator {
    CvI() {
        this.operandTypes = new Class[]{PSObject.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        try {
            if (os.checkType(PSNumber.class)) {
                PSNumber n = os.popNumber();
                os.push(n.getInt());
            } else if (os.checkType(PSString.class)) {
                PSString s = os.popString();
                PSNumber n = PSUtils.parseNumber(s.getValue());
                os.push(n.getInt());
            } else {
                CvI.error(os, new TypeCheck());
            }
        }
        catch (NumberFormatException e) {
            CvI.error(os, new UndefinedResult());
        }
        catch (RangeException e) {
            CvI.error(os, new RangeCheck());
        }
        return true;
    }
}

