/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.GeneralOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSArray;
import org.freehep.postscript.PSDictionary;
import org.freehep.postscript.PSGState;
import org.freehep.postscript.PSInteger;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.PSString;
import org.freehep.postscript.RangeCheck;
import org.freehep.postscript.TypeCheck;

class Copy
extends GeneralOperator {
    Copy() {
    }

    @Override
    public boolean execute(OperandStack os) {
        if (os.checkType(PSInteger.class)) {
            int n = os.popInteger().getValue();
            if (n < 0 || n > os.size()) {
                Copy.error(os, new RangeCheck());
            } else {
                os.copy(n);
            }
        } else if (os.checkType(PSArray.class, PSArray.class) || os.checkType(PSPackedArray.class, PSArray.class)) {
            PSArray a2 = os.popArray();
            PSPackedArray a1 = os.popPackedArray();
            if (a2.size() < a1.size()) {
                Copy.error(os, new RangeCheck());
            } else {
                for (int i = 0; i < a1.size(); ++i) {
                    a2.set(i, a1.get(i));
                }
                os.push(a2.subArray(0, a1.size()));
            }
        } else if (os.checkType(PSDictionary.class, PSDictionary.class)) {
            PSDictionary d2 = os.popDictionary();
            PSDictionary d1 = os.popDictionary();
            d1.copyInto(d2);
            os.push(d2);
        } else if (os.checkType(PSString.class, PSString.class)) {
            PSString s2 = os.popString();
            PSString s1 = os.popString();
            if (s2.size() < s1.size()) {
                Copy.error(os, new RangeCheck());
            } else {
                for (int i = 0; i < s1.size(); ++i) {
                    s2.set(i, s1.get(i));
                }
                os.push(s2.subString(0, s1.size()));
            }
        } else if (os.checkType(PSGState.class, PSGState.class)) {
            PSGState g2 = os.popGState();
            PSGState g1 = os.popGState();
            g1.copyInto(g2);
            os.push(g2);
        } else {
            Copy.error(os, new TypeCheck());
        }
        return true;
    }
}

