/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

public class ByteBuffer {
    private char[] buffer;
    private int len;

    public ByteBuffer() {
        this(256);
    }

    public ByteBuffer(int len) {
        this.buffer = new char[len];
        this.reset();
    }

    public void reset() {
        this.len = 0;
    }

    public void append(int i) {
        this.append((char)i);
    }

    public void append(char c) {
        if (this.len >= this.buffer.length) {
            char[] newBuffer = new char[this.buffer.length * 2];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.len);
            this.buffer = newBuffer;
        }
        this.buffer[this.len] = c;
        ++this.len;
    }

    public String getString() {
        return new String(this.buffer, 0, this.len);
    }

    public char[] getChars() {
        char[] r = new char[this.len];
        System.arraycopy(this.buffer, 0, r, 0, this.len);
        return r;
    }
}

