/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import org.freehep.postscript.DictionaryStack;
import org.freehep.postscript.MiscellaneousOperator;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSArray;
import org.freehep.postscript.PSName;
import org.freehep.postscript.PSObject;
import org.freehep.postscript.PSOperator;
import org.freehep.postscript.PSPackedArray;
import org.freehep.postscript.PackedArray;
import org.freehep.postscript.TypeCheck;

class Bind
extends MiscellaneousOperator {
    Bind() {
        this.operandTypes = new Class[]{PSPackedArray.class};
    }

    @Override
    public boolean execute(OperandStack os) {
        PSPackedArray p = os.popPackedArray();
        if (p.isLiteral()) {
            Bind.error(os, new TypeCheck());
        } else {
            this.bind(p, os.dictStack());
            os.push(p);
        }
        return true;
    }

    private void bind(PSPackedArray p, DictionaryStack ds) {
        if (p instanceof PSArray) {
            if (p.accessWrite()) {
                p.changeAccess(2);
            } else {
                return;
            }
        }
        for (int i = 0; i < p.size(); ++i) {
            PSObject key = p.get(i);
            if (key.isExecutable() && key instanceof PSName) {
                PSObject value = ds.lookup(key);
                if (!(value instanceof PSOperator)) continue;
                p.bind(i, (PSOperator)value);
                continue;
            }
            if (!(key instanceof PackedArray)) continue;
            this.bind((PSPackedArray)key, ds);
        }
    }
}

