/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.freehep.postscript.FontOperator;
import org.freehep.postscript.NoCurrentPoint;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSGState;
import org.freehep.postscript.PSInteger;
import org.freehep.postscript.PSNumber;
import org.freehep.postscript.PSString;
import org.freehep.postscript.TypeCheck;

class AWidthShow
extends FontOperator {
    private String text;
    private int index;
    private int chd;
    private double ax;
    private double ay;
    private double cx;
    private double cy;

    public AWidthShow(String t, int c, double xc, double yc, double xa, double ya) {
        this.text = t;
        this.index = -1;
        this.chd = c;
        this.cx = xc;
        this.cy = yc;
        this.ax = xa;
        this.ay = ya;
    }

    public AWidthShow() {
    }

    @Override
    public boolean execute(OperandStack os) {
        PSGState gs = os.gstate();
        if (this.text == null) {
            if (!os.checkType(new Class[]{PSNumber.class, PSNumber.class, PSInteger.class, PSNumber.class, PSNumber.class, PSString.class})) {
                AWidthShow.error(os, new TypeCheck());
                return true;
            }
            Point2D point = gs.position();
            if (point == null) {
                AWidthShow.error(os, new NoCurrentPoint());
                return true;
            }
            float x0 = (float)point.getX();
            float y0 = (float)point.getY();
            String t = os.popString().getValue();
            double ay = os.popNumber().getDouble();
            double ax = os.popNumber().getDouble();
            int c = os.popInteger().getValue();
            double yc = os.popNumber().getDouble();
            double xc = os.popNumber().getDouble();
            os.execStack().pop();
            os.execStack().push(new AWidthShow(t, c, xc, yc, ax, ay));
            os.gsave();
            double[] cfm = gs.font().getPackedArray("FontMatrix").toDoubles();
            AffineTransform at = new AffineTransform(cfm[0], cfm[1], cfm[2], cfm[3], (double)x0, (double)y0);
            gs.transform(at);
            return false;
        }
        if (this.index >= 0) {
            double wx = this.currentGlyph.wx + this.ax;
            double wy = this.currentGlyph.wy + this.ay;
            if (this.text.charAt(this.index) == this.chd) {
                wx += this.cx;
                wy += this.cy;
            }
            os.gstate().translate(wx, wy);
        }
        ++this.index;
        if (this.index >= this.text.length()) {
            os.grestore();
            return true;
        }
        char ch = this.text.charAt(this.index);
        this.show(os, ch);
        return false;
    }
}

