/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.postscript;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.freehep.postscript.FontOperator;
import org.freehep.postscript.NoCurrentPoint;
import org.freehep.postscript.OperandStack;
import org.freehep.postscript.PSGState;
import org.freehep.postscript.PSNumber;
import org.freehep.postscript.PSString;
import org.freehep.postscript.TypeCheck;

class AShow
extends FontOperator {
    private String text;
    private int index;
    private double ax;
    private double ay;

    public AShow() {
    }

    public AShow(String t, double xa, double ya) {
        this.text = t;
        this.ax = xa;
        this.ay = ya;
        this.index = 0;
    }

    @Override
    public boolean execute(OperandStack os) {
        PSGState gs = os.gstate();
        if (this.text == null) {
            if (!os.checkType(PSNumber.class, PSNumber.class, PSString.class)) {
                AShow.error(os, new TypeCheck());
                return true;
            }
            Point2D point = gs.position();
            if (point == null) {
                AShow.error(os, new NoCurrentPoint());
                return true;
            }
            float x0 = (float)point.getX();
            float y0 = (float)point.getY();
            String t = os.popString().getValue();
            double ya = os.popNumber().getDouble();
            double xa = os.popNumber().getDouble();
            os.execStack().pop();
            os.execStack().push(new AShow(t, ya, xa));
            os.gsave();
            double[] cfm = gs.font().getPackedArray("FontMatrix").toDoubles();
            AffineTransform at = new AffineTransform(cfm[0], cfm[1], cfm[2], cfm[3], (double)x0, (double)y0);
            gs.transform(at);
            return false;
        }
        if (this.index >= 0) {
            os.gstate().translate(this.currentGlyph.wx + this.ax, this.currentGlyph.wy + this.ay);
        }
        ++this.index;
        if (this.index >= this.text.length()) {
            os.grestore();
            return true;
        }
        char ch = this.text.charAt(this.index);
        this.show(os, ch);
        return false;
    }
}

