/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.math.minuit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.freehep.math.minuit.MinuitParameter;
import org.freehep.math.minuit.MnAlgebraicSymMatrix;
import org.freehep.math.minuit.MnAlgebraicVector;
import org.freehep.math.minuit.MnMachinePrecision;
import org.freehep.math.minuit.MnUserCovariance;
import org.freehep.math.minuit.SinParameterTransformation;
import org.freehep.math.minuit.SqrtLowParameterTransformation;
import org.freehep.math.minuit.SqrtUpParameterTransformation;

class MnUserTransformation {
    private MnMachinePrecision thePrecision;
    private List<MinuitParameter> theParameters;
    private List<Integer> theExtOfInt;
    private Map<String, Integer> nameMap = new HashMap<String, Integer>();
    private SinParameterTransformation theDoubleLimTrafo;
    private SqrtUpParameterTransformation theUpperLimTrafo;
    private SqrtLowParameterTransformation theLowerLimTrafo;
    private List<Double> theCache;

    MnUserTransformation() {
        this.thePrecision = new MnMachinePrecision();
        this.theParameters = new ArrayList<MinuitParameter>();
        this.theExtOfInt = new ArrayList<Integer>();
        this.theDoubleLimTrafo = new SinParameterTransformation();
        this.theUpperLimTrafo = new SqrtUpParameterTransformation();
        this.theLowerLimTrafo = new SqrtLowParameterTransformation();
        this.theCache = new ArrayList<Double>(0);
    }

    protected MnUserTransformation clone() {
        return new MnUserTransformation(this);
    }

    private MnUserTransformation(MnUserTransformation other) {
        this.thePrecision = other.thePrecision;
        this.theParameters = new ArrayList<MinuitParameter>(other.theParameters.size());
        for (MinuitParameter par : other.theParameters) {
            this.theParameters.add(par.clone());
        }
        this.theExtOfInt = new ArrayList<Integer>(other.theExtOfInt);
        this.theDoubleLimTrafo = new SinParameterTransformation();
        this.theUpperLimTrafo = new SqrtUpParameterTransformation();
        this.theLowerLimTrafo = new SqrtLowParameterTransformation();
        this.theCache = new ArrayList<Double>(other.theCache);
    }

    MnAlgebraicVector transform(MnAlgebraicVector pstates) {
        int i;
        MnAlgebraicVector result = new MnAlgebraicVector(this.theCache.size());
        for (i = 0; i < result.size(); ++i) {
            result.set(i, this.theCache.get(i));
        }
        for (i = 0; i < pstates.size(); ++i) {
            if (this.theParameters.get(this.theExtOfInt.get(i)).hasLimits()) {
                result.set(this.theExtOfInt.get(i), this.int2ext(i, pstates.get(i)));
                continue;
            }
            result.set(this.theExtOfInt.get(i), pstates.get(i));
        }
        return result;
    }

    MnUserTransformation(double[] par, double[] err) {
        this.thePrecision = new MnMachinePrecision();
        this.theDoubleLimTrafo = new SinParameterTransformation();
        this.theUpperLimTrafo = new SqrtUpParameterTransformation();
        this.theLowerLimTrafo = new SqrtLowParameterTransformation();
        this.theParameters = new ArrayList<MinuitParameter>(par.length);
        this.theExtOfInt = new ArrayList<Integer>(par.length);
        this.theCache = new ArrayList<Double>(par.length);
        for (int i = 0; i < par.length; ++i) {
            this.add("p" + i, par[i], err[i]);
        }
    }

    MnMachinePrecision precision() {
        return this.thePrecision;
    }

    void setPrecision(double eps) {
        this.thePrecision.setPrecision(eps);
    }

    List<MinuitParameter> parameters() {
        return this.theParameters;
    }

    int variableParameters() {
        return this.theExtOfInt.size();
    }

    double[] params() {
        double[] result = new double[this.theParameters.size()];
        int i = 0;
        for (MinuitParameter parameter : this.theParameters) {
            result[i++] = parameter.value();
        }
        return result;
    }

    double[] errors() {
        double[] result = new double[this.theParameters.size()];
        int i = 0;
        for (MinuitParameter parameter : this.theParameters) {
            result[i++] = parameter.error();
        }
        return result;
    }

    MinuitParameter parameter(int index) {
        return this.theParameters.get(index);
    }

    void add(String name, double val, double err) {
        if (this.nameMap.containsKey(name)) {
            throw new IllegalArgumentException("duplicate name: " + name);
        }
        this.nameMap.put(name, this.theParameters.size());
        this.theExtOfInt.add(this.theParameters.size());
        this.theCache.add(val);
        this.theParameters.add(new MinuitParameter(this.theParameters.size(), name, val, err));
    }

    void add(String name, double val, double err, double low, double up) {
        if (this.nameMap.containsKey(name)) {
            throw new IllegalArgumentException("duplicate name: " + name);
        }
        this.nameMap.put(name, this.theParameters.size());
        this.theExtOfInt.add(this.theParameters.size());
        this.theCache.add(val);
        this.theParameters.add(new MinuitParameter(this.theParameters.size(), name, val, err, low, up));
    }

    void add(String name, double val) {
        if (this.nameMap.containsKey(name)) {
            throw new IllegalArgumentException("duplicate name: " + name);
        }
        this.nameMap.put(name, this.theParameters.size());
        this.theCache.add(val);
        this.theParameters.add(new MinuitParameter(this.theParameters.size(), name, val));
    }

    void fix(int index) {
        int iind = this.intOfExt(index);
        this.theExtOfInt.remove(iind);
        this.theParameters.get(index).fix();
    }

    void release(int index) {
        if (this.theExtOfInt.contains(index)) {
            throw new IllegalArgumentException("index=" + index);
        }
        this.theExtOfInt.add(index);
        Collections.sort(this.theExtOfInt);
        this.theParameters.get(index).release();
    }

    void setValue(int index, double val) {
        this.theParameters.get(index).setValue(val);
        this.theCache.set(index, val);
    }

    void setError(int index, double err) {
        this.theParameters.get(index).setError(err);
    }

    void setLimits(int index, double low, double up) {
        this.theParameters.get(index).setLimits(low, up);
    }

    void setUpperLimit(int index, double up) {
        this.theParameters.get(index).setUpperLimit(up);
    }

    void setLowerLimit(int index, double low) {
        this.theParameters.get(index).setLowerLimit(low);
    }

    void removeLimits(int index) {
        this.theParameters.get(index).removeLimits();
    }

    double value(int index) {
        return this.theParameters.get(index).value();
    }

    double error(int index) {
        return this.theParameters.get(index).error();
    }

    void fix(String name) {
        this.fix(this.index(name));
    }

    void release(String name) {
        this.release(this.index(name));
    }

    void setValue(String name, double val) {
        this.setValue(this.index(name), val);
    }

    void setError(String name, double err) {
        this.setError(this.index(name), err);
    }

    void setLimits(String name, double low, double up) {
        this.setLimits(this.index(name), low, up);
    }

    void setLowerLimit(String name, double low) {
        this.setLowerLimit(this.index(name), low);
    }

    void setUpperLimit(String name, double up) {
        this.setUpperLimit(this.index(name), up);
    }

    void removeLimits(String name) {
        this.removeLimits(this.index(name));
    }

    double value(String name) {
        return this.value(this.index(name));
    }

    double error(String name) {
        return this.error(this.index(name));
    }

    int index(String name) {
        return this.nameMap.get(name);
    }

    String name(int index) {
        return this.theParameters.get(index).name();
    }

    double int2ext(int i, double val) {
        MinuitParameter parm = this.theParameters.get(this.theExtOfInt.get(i));
        if (parm.hasLimits()) {
            if (parm.hasUpperLimit() && parm.hasLowerLimit()) {
                return this.theDoubleLimTrafo.int2ext(val, parm.upperLimit(), parm.lowerLimit());
            }
            if (parm.hasUpperLimit() && !parm.hasLowerLimit()) {
                return this.theUpperLimTrafo.int2ext(val, parm.upperLimit());
            }
            return this.theLowerLimTrafo.int2ext(val, parm.lowerLimit());
        }
        return val;
    }

    double int2extError(int i, double val, double err) {
        double dx = err;
        MinuitParameter parm = this.theParameters.get(this.theExtOfInt.get(i));
        if (parm.hasLimits()) {
            double ui = this.int2ext(i, val);
            double du1 = this.int2ext(i, val + dx) - ui;
            double du2 = this.int2ext(i, val - dx) - ui;
            if (parm.hasUpperLimit() && parm.hasLowerLimit()) {
                if (dx > 1.0) {
                    du1 = parm.upperLimit() - parm.lowerLimit();
                }
                dx = 0.5 * (Math.abs(du1) + Math.abs(du2));
            } else {
                dx = 0.5 * (Math.abs(du1) + Math.abs(du2));
            }
        }
        return dx;
    }

    MnUserCovariance int2extCovariance(MnAlgebraicVector vec, MnAlgebraicSymMatrix cov) {
        MnUserCovariance result = new MnUserCovariance(cov.nrow());
        for (int i = 0; i < vec.size(); ++i) {
            double dxdi = 1.0;
            if (this.theParameters.get(this.theExtOfInt.get(i)).hasLimits()) {
                dxdi = this.dInt2Ext(i, vec.get(i));
            }
            for (int j = i; j < vec.size(); ++j) {
                double dxdj = 1.0;
                if (this.theParameters.get(this.theExtOfInt.get(j)).hasLimits()) {
                    dxdj = this.dInt2Ext(j, vec.get(j));
                }
                result.set(i, j, dxdi * cov.get(i, j) * dxdj);
            }
        }
        return result;
    }

    double ext2int(int i, double val) {
        MinuitParameter parm = this.theParameters.get(i);
        if (parm.hasLimits()) {
            if (parm.hasUpperLimit() && parm.hasLowerLimit()) {
                return this.theDoubleLimTrafo.ext2int(val, parm.upperLimit(), parm.lowerLimit(), this.precision());
            }
            if (parm.hasUpperLimit() && !parm.hasLowerLimit()) {
                return this.theUpperLimTrafo.ext2int(val, parm.upperLimit(), this.precision());
            }
            return this.theLowerLimTrafo.ext2int(val, parm.lowerLimit(), this.precision());
        }
        return val;
    }

    double dInt2Ext(int i, double val) {
        double dd = 1.0;
        MinuitParameter parm = this.theParameters.get(this.theExtOfInt.get(i));
        if (parm.hasLimits()) {
            dd = parm.hasUpperLimit() && parm.hasLowerLimit() ? this.theDoubleLimTrafo.dInt2Ext(val, parm.upperLimit(), parm.lowerLimit()) : (parm.hasUpperLimit() && !parm.hasLowerLimit() ? this.theUpperLimTrafo.dInt2Ext(val, parm.upperLimit()) : this.theLowerLimTrafo.dInt2Ext(val, parm.lowerLimit()));
        }
        return dd;
    }

    int intOfExt(int ext) {
        for (int iind = 0; iind < this.theExtOfInt.size(); ++iind) {
            if (ext != this.theExtOfInt.get(iind)) continue;
            return iind;
        }
        throw new IllegalArgumentException("ext=" + ext);
    }

    int extOfInt(int internal) {
        return this.theExtOfInt.get(internal);
    }
}

