/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.cgm;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.IOException;
import org.freehep.graphicsio.cgm.CGMOutputStream;
import org.freehep.graphicsio.cgm.CGMTag;
import org.freehep.graphicsio.cgm.CGMWriter;

public class CellArray
extends CGMTag {
    public static final int RUN_LENGTH = 0;
    public static final int PACKED = 1;
    private Point2D p;
    private Point2D q;
    private Point2D r;
    private Color[][] colorArray;
    private int precision;
    private int mode;

    public CellArray() {
        super(4, 9, 1);
    }

    private CellArray(Point2D p, Point2D q, Point2D r, Color[][] colorArray, int precision, int mode) {
        this();
        this.p = p;
        this.q = q;
        this.r = r;
        this.colorArray = colorArray;
        this.precision = precision;
        this.mode = mode;
    }

    public CellArray(Point2D p, Point2D q, Point2D r, Color[][] colorArray) {
        this(p, q, r, colorArray, 8, 1);
    }

    @Override
    public void write(int tagID, CGMOutputStream cgm) throws IOException {
        cgm.writePoint(this.p);
        cgm.writePoint(this.q);
        cgm.writePoint(this.r);
        cgm.writeInteger(this.colorArray[0].length);
        cgm.writeInteger(this.colorArray.length);
        cgm.writeInteger(this.precision);
        cgm.writeEnumerate(this.mode);
        cgm.pushBuffer();
        for (int i = 0; i < this.colorArray.length; ++i) {
            this.wordAlign(cgm);
            for (int j = 0; j < this.colorArray[0].length; ++j) {
                cgm.writeColor(this.colorArray[i][j]);
            }
        }
        cgm.popBuffer();
        cgm.append();
    }

    private void wordAlign(CGMOutputStream cgm) throws IOException {
        int align = 2;
        int pad = (align - cgm.getBufferLength() % align) % align;
        for (int i = 0; i < pad; ++i) {
            cgm.write(0);
        }
    }

    @Override
    public void write(int tagID, CGMWriter cgm) throws IOException {
        cgm.println("CELLARRAY");
        cgm.indent();
        cgm.writePoint(this.p);
        cgm.println(",");
        cgm.writePoint(this.q);
        cgm.println(",");
        cgm.writePoint(this.r);
        cgm.println(",");
        cgm.writeInteger(this.colorArray[0].length);
        cgm.println(",");
        cgm.writeInteger(this.colorArray.length);
        cgm.println(",");
        cgm.writeInteger(this.precision);
        cgm.println(",");
        for (int i = 0; i < this.colorArray.length; ++i) {
            cgm.print("(");
            int widthMinus1 = this.colorArray[0].length - 1;
            for (int j = 0; j < widthMinus1; ++j) {
                cgm.writeColor(this.colorArray[i][j]);
                cgm.print(", ");
            }
            cgm.writeColor(this.colorArray[i][widthMinus1]);
            if (i == this.colorArray.length - 1) {
                cgm.print(")");
                continue;
            }
            cgm.println(") ,");
        }
        cgm.outdent();
    }
}

