/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.cgm;

import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsio.cgm.CGMGraphics2D;
import org.freehep.graphicsio.exportchooser.AbstractExportFileType;
import org.freehep.graphicsio.exportchooser.BackgroundPanel;
import org.freehep.graphicsio.exportchooser.InfoPanel;
import org.freehep.graphicsio.exportchooser.OptionCheckBox;
import org.freehep.graphicsio.exportchooser.OptionPanel;

public class CGMExportFileType
extends AbstractExportFileType {
    @Override
    public String getDescription() {
        return "Computer Graphics Metafile";
    }

    @Override
    public String[] getExtensions() {
        return new String[]{"cgm"};
    }

    @Override
    public String[] getMIMETypes() {
        return new String[]{"image/cgm"};
    }

    @Override
    public boolean hasOptionPanel() {
        return true;
    }

    @Override
    public JPanel createOptionPanel(Properties user) {
        UserProperties options = new UserProperties(user, CGMGraphics2D.getDefaultProperties());
        OptionPanel formatPanel = new OptionPanel("Format");
        formatPanel.add("0 * * 1 [5 15 5 15] w", new OptionCheckBox(options, CGMGraphics2D.BINARY, "Binary"));
        String rootKey = CGMGraphics2D.class.getName();
        InfoPanel infoPanel = new InfoPanel(options, rootKey, new String[]{"Author", "Title", "Subject", "Keywords"});
        OptionPanel leftPanel = new OptionPanel();
        leftPanel.add("0 * wt", formatPanel);
        leftPanel.add("0 * wh", new JLabel());
        OptionPanel rightPanel = new OptionPanel();
        rightPanel.add("0 * wt", new BackgroundPanel(options, rootKey, false));
        rightPanel.add("0 * wh", new JLabel());
        OptionPanel optionsPanel = new OptionPanel();
        optionsPanel.add("0 0 [5 5 5 5] wt", leftPanel);
        optionsPanel.add("1 0 [5 5 5 5] wt", rightPanel);
        optionsPanel.add("0 1 2 1 [5 5 5 5] wt", infoPanel);
        optionsPanel.add("0 * wh", new JLabel());
        return optionsPanel;
    }

    @Override
    public VectorGraphics getGraphics(OutputStream os, Component target) throws IOException {
        return new CGMGraphics2D(os, target);
    }

    @Override
    public VectorGraphics getGraphics(OutputStream os, Dimension dimension) throws IOException {
        return null;
    }
}

