/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.application.studio.pluginmanager;

import java.awt.GridLayout;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

class PluginDownload
extends JPanel
implements Runnable {
    private Map files;
    private Map downloads;
    private Throwable status;
    private JLabel label1;
    private JLabel label2;
    private JProgressBar progress1;
    private JProgressBar progress2;

    PluginDownload(Map files) {
        super(new GridLayout(4, 1));
        this.files = files;
        int n = files.size();
        this.label1 = new JLabel("File 1/" + n);
        this.label2 = new JLabel("Downloading ...");
        this.progress1 = new JProgressBar(0, n);
        this.progress2 = new JProgressBar();
        this.add(this.label1);
        this.add(this.progress1);
        this.add(this.label2);
        this.add(this.progress2);
    }

    Throwable getStatus() {
        return this.status;
    }

    void cleanUp() {
        this.downloads = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commit() {
        try {
            System.out.println("commit" + this.downloads.size());
            for (Map.Entry entry : this.downloads.entrySet()) {
                ByteArrayOutputStream bytes = (ByteArrayOutputStream)entry.getValue();
                System.out.println("file=" + entry.getKey());
                FileOutputStream out = new FileOutputStream((File)entry.getKey());
                bytes.writeTo(out);
                ((OutputStream)out).close();
            }
        }
        catch (IOException x) {
            x.printStackTrace();
        }
        finally {
            this.downloads = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.downloads = new HashMap();
            Iterator iter = this.files.entrySet().iterator();
            int i = 0;
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                URL url = new URL(entry.getValue().toString());
                SwingUtilities.invokeLater(new Update(i, url));
                URLConnection connect = url.openConnection();
                InputStream in = connect.getInputStream();
                byte[] buffer = new byte[8196];
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    int l;
                    while ((l = in.read(buffer)) >= 0) {
                        ((OutputStream)out).write(buffer, 0, l);
                    }
                    ((OutputStream)out).close();
                    this.downloads.put(entry.getKey(), out);
                }
                catch (EOFException x) {
                }
                finally {
                    in.close();
                }
                ++i;
            }
        }
        catch (Throwable t) {
            this.status = t;
        }
        finally {
            System.out.println("Download finished");
            SwingUtilities.invokeLater(new Update(this.files.size(), null));
        }
    }

    private class Update
    implements Runnable {
        private int n;
        private URL url;

        Update(int n, URL url) {
            this.n = n;
            this.url = url;
        }

        @Override
        public void run() {
            PluginDownload.this.label1.setText("File " + (this.n + 1) + "/" + PluginDownload.this.files.size());
            PluginDownload.this.progress1.setValue(this.n);
            if (this.url == null) {
                JDialog dlg = (JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, PluginDownload.this);
                System.out.println("dlg=" + dlg);
                if (dlg != null) {
                    dlg.dispose();
                }
            } else {
                PluginDownload.this.label2.setText("Downloading " + this.url + "...");
            }
        }
    }
}

