/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.aid;

import org.freehep.aid.AidUtil;
import org.freehep.rtti.IMethod;
import org.freehep.rtti.IType;
import org.freehep.util.UserProperties;

public class CPPTypeConverter {
    protected UserProperties typeProperties = new UserProperties();
    protected UserProperties includeProperties = new UserProperties();
    protected UserProperties importProperties = new UserProperties();

    public CPPTypeConverter(String propDir) {
        AidUtil.loadProperties(this.typeProperties, this.getClass(), propDir, "aid.types.cpp.properties");
        AidUtil.loadProperties(this.includeProperties, this.getClass(), propDir, "aid.includes.cpp.properties");
        AidUtil.loadProperties(this.importProperties, this.getClass(), propDir, "aid.imports.java.properties");
    }

    public String namespace(String packageName) {
        String namespace = packageName;
        if (!namespace.equals("")) {
            namespace = this.typeProperties.getProperty(namespace, namespace);
        }
        namespace = namespace.replaceAll("\\.", "::");
        return namespace;
    }

    public String name(String name) {
        return this.typeProperties.getProperty(name, name);
    }

    public String qualifiedName(String name, String nameSpace) {
        String targetNameSpace;
        String qualifiedName = this.typeProperties.getProperty(name, name);
        int colon = qualifiedName.lastIndexOf("::");
        if (colon >= 0 && (targetNameSpace = qualifiedName.substring(0, colon)).equals(nameSpace)) {
            qualifiedName = qualifiedName.substring(colon + 2);
        }
        return qualifiedName;
    }

    protected String type(IType type, String nameSpace) {
        StringBuffer s = new StringBuffer();
        if (type.isConst()) {
            s.append("const ");
        }
        s.append(this.basicType(type, nameSpace));
        if (type.isReference()) {
            s.append(" &");
        }
        for (int i = 0; i < type.getPointer(); ++i) {
            s.append(" *");
        }
        return s.toString();
    }

    protected String basicType(IType type, String nameSpace) {
        return this.basicType(type, type.getDimension(), nameSpace);
    }

    protected String basicType(IType type, int dimension, String nameSpace) {
        int i;
        IType[] types = type.getTypes();
        StringBuffer s = new StringBuffer();
        for (int i2 = 0; i2 < dimension; ++i2) {
            s.append("std::vector<");
        }
        String typeName = type.getName();
        if (typeName.equals("[]")) {
            s.append(this.type(types[0], nameSpace));
        } else {
            s.append(this.qualifiedName(typeName, nameSpace));
            if (types.length > 0) {
                s.append("<");
                s.append(this.type(types[0], nameSpace));
                for (i = 1; i < types.length; ++i) {
                    s.append(", ");
                    s.append(this.type(types[i], nameSpace));
                }
                s.append("> ");
            }
        }
        for (i = 0; i < dimension; ++i) {
            s.append("> ");
        }
        return s.toString();
    }

    public String getSignature(IType type, int dimension, String packageName) {
        if (dimension == 0) {
            String s = type.getSignature(packageName, this.importProperties);
            s = s.substring(type.getDimension() + 1, s.length() - 1);
            s = s.replace('/', '.');
            return s;
        }
        return "java.lang.Object";
    }

    public String getSignature(IMethod method, String packageName) {
        String s = method.getSignature(packageName, this.importProperties);
        s = s.replace('(', 'O');
        s = s.replace(')', 'C');
        s = s.replace(';', 'E');
        s = s.replace('[', 'A');
        s = s.replace('/', '_');
        s = s.replace('$', 'S');
        return s;
    }
}

