/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.aid;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.freehep.aid.AbstractGenerator;
import org.freehep.aid.AidUtil;
import org.freehep.aid.CPPTypeConverter;
import org.freehep.aid.cli.Aid;
import org.freehep.rtti.IClass;
import org.freehep.rtti.IPackage;
import org.freehep.util.UserProperties;
import org.freehep.util.io.IndentPrintWriter;

public class CPPPackageHeaderGenerator
extends AbstractGenerator {
    protected static final String language = "cpp";
    protected CPPTypeConverter converter;
    protected UserProperties includeProperties = new UserProperties();

    public CPPPackageHeaderGenerator(String propDir) {
        AidUtil.loadProperties(this.properties, this.getClass(), propDir, "aid.cpp.properties");
        AidUtil.loadProperties(this.includeProperties, this.getClass(), propDir, "aid.includes.cpp.properties");
        this.converter = new CPPTypeConverter(propDir);
    }

    protected String namespace(IClass clazz) {
        return this.converter.namespace(clazz.getPackageName());
    }

    @Override
    public String directory(IClass clazz) {
        return this.namespace(clazz).replaceAll("::", "_");
    }

    @Override
    public String filename(IClass clazz) {
        String name = this.directory(clazz);
        if (name.equals("")) {
            name = "DEFAULT";
        }
        return name + ".h";
    }

    @Override
    public boolean print(File file, IClass clazz) throws IOException {
        IndentPrintWriter out = new IndentPrintWriter(new PrintWriter(new BufferedWriter(new FileWriter(file))));
        out.setIndentString("    ");
        out.println("// -*- C++ -*-");
        this.warning(out);
        String define = this.filename(clazz).toUpperCase().replaceAll("::", "_").replaceAll("\\.", "_");
        out.println("#ifndef " + define);
        out.println("#define " + define + " 1");
        out.println();
        IPackage[] p = Aid.getRTTI().getPackages();
        for (int i = 0; i < p.length; ++i) {
            IClass[] c = p[i].getClasses();
            for (int j = 0; j < c.length; ++j) {
                IClass cls = c[j];
                String name = this.converter.qualifiedName(cls.getName(), "");
                out.println("#include \"" + this.includeProperties.getProperty(name, name) + "\"");
            }
        }
        out.println();
        out.println("#endif /* ifndef " + define + " */");
        out.close();
        return true;
    }
}

