/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.aid;

import java.util.SortedSet;
import org.freehep.aid.AbstractCPPHeaderGenerator;
import org.freehep.rtti.IClass;
import org.freehep.rtti.IField;
import org.freehep.rtti.IMethod;
import org.freehep.rtti.INamedType;
import org.freehep.rtti.IType;
import org.freehep.util.io.IndentPrintWriter;

public class CPPHeaderGenerator
extends AbstractCPPHeaderGenerator {
    public CPPHeaderGenerator(String propDir) {
        super(propDir);
    }

    @Override
    public String directory(IClass clazz) {
        return this.namespace(clazz).replaceAll("::", "_");
    }

    @Override
    public String filename(IClass clazz) {
        return clazz.getName() + ".h";
    }

    @Override
    protected void includeStatements(IClass clazz, SortedSet sysIncludes, SortedSet includes, String namespace, SortedSet types) {
        String[] interfaces = clazz.getInterfaces();
        if (interfaces.length > 0) {
            for (int i = 0; i < interfaces.length; ++i) {
                this.includeFrom(this.prefix() + interfaces[i], this.prefix() + clazz.getName(), sysIncludes, includes, "", includes);
            }
        }
        IField[] fields = clazz.getFields();
        for (int i = 0; i < fields.length; ++i) {
            IType type = fields[i].getNamedType().getType();
            if (type.isConst()) continue;
            this.includeFrom(type, this.prefix() + clazz.getName(), sysIncludes, includes, namespace, types);
        }
        super.includeStatements(clazz, sysIncludes, includes, namespace, types);
    }

    @Override
    protected void printClassHeader(IndentPrintWriter out, IClass clazz) {
        boolean useVirtualInheritance = this.properties.isProperty("useVirtualInheritance", true);
        String[] templateParameters = clazz.getTemplateParameters();
        if (templateParameters.length > 0) {
            out.print("template <class ");
            out.print(templateParameters[0]);
            for (int i = 1; i < templateParameters.length; ++i) {
                out.print(", class ");
                out.print(templateParameters[i]);
            }
            out.println(">");
        }
        out.print("class " + clazz.getName());
        String[] interfaces = clazz.getInterfaces();
        int k = 0;
        for (int i = 0; i < interfaces.length; ++i) {
            String cppInterface = this.converter.qualifiedName(interfaces[i], this.namespace(clazz));
            if (cppInterface.equals("")) continue;
            out.print(k == 0 ? " : " : ", ");
            if (useVirtualInheritance) {
                out.print("virtual ");
            }
            out.print("public ");
            out.print(cppInterface);
            ++k;
        }
        out.println(" {");
    }

    @Override
    protected void printPublic(IndentPrintWriter out, IClass clazz) {
        out.println();
        out.println("public: ");
        out.println("    /// Destructor.");
        out.println("    virtual ~" + clazz.getName() + "() { /* nop */; }");
    }

    @Override
    protected void printMethod(IndentPrintWriter out, IMethod method, String nameSpace) {
        super.printMethod(out, method, nameSpace);
        out.print(" = 0");
        out.println(";");
    }

    @Override
    protected boolean printDefines(IndentPrintWriter out, IClass clazz) {
        boolean writeClass = false;
        IField[] fields = clazz.getFields();
        for (int j = 0; j < fields.length; ++j) {
            IField field = fields[j];
            IType type = field.getNamedType().getType();
            if (!type.isConst() || type.isEnumeration()) {
                writeClass = true;
                continue;
            }
            String[] comments = field.getComments("cpp");
            if (comments.length > 0) {
                out.println();
                for (int i = 0; i < comments.length; ++i) {
                    out.println(comments[i]);
                }
            }
            while (field != null) {
                INamedType namedType = field.getNamedType();
                out.print("#define ");
                out.print(namedType.getName());
                out.print(" ");
                String init = namedType.getInit();
                if (init != null) {
                    init = this.valueProperties.getProperty(init, init);
                }
                if (init != null && !init.equals("")) {
                    out.print(init);
                } else {
                    out.print("\"Constants should be initialized.\"");
                }
                out.println();
                field = field.getNext();
            }
        }
        if (clazz.getMethods().length > 0 || clazz.getMethods().length == 0 && clazz.getFields().length == 0) {
            writeClass = true;
        }
        return writeClass;
    }

    @Override
    protected void printField(IndentPrintWriter out, IField field, String nameSpace) {
        IType type = field.getNamedType().getType();
        if (type.isConst() && !type.isEnumeration()) {
            return;
        }
        out.println();
        String[] comments = field.getComments("cpp");
        for (int i = 0; i < comments.length; ++i) {
            out.println(comments[i]);
        }
        out.print("    ");
        if (type.isEnumeration()) {
            out.print("enum");
            if (type.getName() != null) {
                out.print(" ");
                out.print(type.getName());
            }
            out.print(" {");
        } else {
            out.print(this.converter.type(type, nameSpace));
        }
        out.print(" ");
        while (field != null) {
            INamedType namedType = field.getNamedType();
            String name = namedType.getName();
            out.print(this.namesProperties.getProperty(name, name));
            String init = namedType.getInit();
            if (init != null) {
                init = this.valueProperties.getProperty(init, init);
            }
            if (init != null && !init.equals("")) {
                out.print(" = ");
                out.print(init);
            }
            if ((field = field.getNext()) == null) continue;
            out.print(", ");
        }
        if (type.isEnumeration()) {
            out.print(" }");
        }
        out.println(";");
    }

    @Override
    protected String namedType(INamedType namedType, String nameSpace) {
        StringBuffer s = new StringBuffer();
        s.append(super.namedType(namedType, nameSpace));
        String init = namedType.getInit();
        if (init != null) {
            init = this.valueProperties.getProperty(init, init);
        }
        if (init != null && !init.equals("")) {
            s.append(" = ");
            s.append(init);
        }
        return s.toString();
    }
}

