/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.vec;

import hep.physics.matrix.Matrix;
import hep.physics.matrix.MatrixOp;
import hep.physics.matrix.MutableMatrix;
import hep.physics.vec.Hep3Matrix;
import hep.physics.vec.VecOp;
import java.io.Serializable;
import org.apache.commons.math3.util.FastMath;

public class BasicHep3Matrix
implements Hep3Matrix,
MutableMatrix,
Serializable {
    static final long serialVersionUID = 1113014806324139899L;
    private double[][] m_dmat;

    public BasicHep3Matrix() {
        this.m_dmat = new double[3][3];
    }

    public BasicHep3Matrix(double e11, double e12, double e13, double e21, double e22, double e23, double e31, double e32, double e33) {
        this.m_dmat = new double[3][3];
        this.m_dmat[0][0] = e11;
        this.m_dmat[0][1] = e12;
        this.m_dmat[0][2] = e13;
        this.m_dmat[1][0] = e21;
        this.m_dmat[1][1] = e22;
        this.m_dmat[1][2] = e23;
        this.m_dmat[2][0] = e31;
        this.m_dmat[2][1] = e32;
        this.m_dmat[2][2] = e33;
    }

    public BasicHep3Matrix(Matrix m) throws MatrixOp.InvalidMatrixException {
        if (m.getNColumns() != 3 || m.getNRows() != 3) {
            throw new MatrixOp.InvalidMatrixException("Not 3x3 matrix");
        }
        this.m_dmat = new double[3][3];
        this.m_dmat[0][0] = m.e(0, 0);
        this.m_dmat[0][1] = m.e(0, 1);
        this.m_dmat[0][2] = m.e(0, 2);
        this.m_dmat[1][0] = m.e(1, 0);
        this.m_dmat[1][1] = m.e(1, 1);
        this.m_dmat[1][2] = m.e(1, 2);
        this.m_dmat[2][0] = m.e(2, 0);
        this.m_dmat[2][1] = m.e(2, 1);
        this.m_dmat[2][2] = m.e(2, 2);
    }

    @Override
    public double e(int row, int column) {
        return this.m_dmat[row][column];
    }

    @Override
    public double det() {
        double cofact1 = this.m_dmat[1][1] * this.m_dmat[2][2] - this.m_dmat[1][2] * this.m_dmat[2][1];
        double cofact2 = this.m_dmat[0][1] * this.m_dmat[2][2] - this.m_dmat[0][2] * this.m_dmat[2][1];
        double cofact3 = this.m_dmat[0][1] * this.m_dmat[1][2] - this.m_dmat[0][2] * this.m_dmat[1][1];
        return this.m_dmat[0][0] * cofact1 - this.m_dmat[1][0] * cofact2 + this.m_dmat[2][0] * cofact3;
    }

    @Override
    public double trace() {
        return this.m_dmat[0][0] + this.m_dmat[1][1] + this.m_dmat[2][2];
    }

    @Override
    public void setElement(int row, int column, double value) {
        this.m_dmat[row][column] = value;
    }

    public void setPassiveEuler(double phi, double theta, double psi) {
        double cth = FastMath.cos((double)theta);
        double sth = FastMath.sin((double)theta);
        double cphi = FastMath.cos((double)phi);
        double sphi = FastMath.sin((double)phi);
        double cpsi = FastMath.cos((double)psi);
        double spsi = FastMath.sin((double)psi);
        this.m_dmat[0][0] = cpsi * cphi - cth * sphi * spsi;
        this.m_dmat[0][1] = cpsi * sphi + cth * cphi * spsi;
        this.m_dmat[0][2] = spsi * sth;
        this.m_dmat[1][0] = -spsi * cphi - cth * sphi * cpsi;
        this.m_dmat[1][1] = -spsi * sphi + cth * cphi * cpsi;
        this.m_dmat[1][2] = cpsi * sth;
        this.m_dmat[2][0] = sth * sphi;
        this.m_dmat[2][1] = -sth * cphi;
        this.m_dmat[2][2] = cth;
    }

    public void setActiveEuler(double phi, double theta, double psi) {
        double cth = FastMath.cos((double)theta);
        double sth = FastMath.sin((double)theta);
        double cphi = FastMath.cos((double)phi);
        double sphi = FastMath.sin((double)phi);
        double cpsi = FastMath.cos((double)psi);
        double spsi = FastMath.sin((double)psi);
        this.m_dmat[0][0] = cpsi * cphi - cth * sphi * spsi;
        this.m_dmat[1][0] = cpsi * sphi + cth * cphi * spsi;
        this.m_dmat[2][0] = spsi * sth;
        this.m_dmat[0][1] = -spsi * cphi - cth * sphi * cpsi;
        this.m_dmat[1][1] = -spsi * sphi + cth * cphi * cpsi;
        this.m_dmat[2][1] = cpsi * sth;
        this.m_dmat[0][2] = sth * sphi;
        this.m_dmat[1][2] = -sth * cphi;
        this.m_dmat[2][2] = cth;
    }

    public static BasicHep3Matrix identity() {
        BasicHep3Matrix result = new BasicHep3Matrix();
        result.m_dmat[0][0] = 1.0;
        result.m_dmat[1][1] = 1.0;
        result.m_dmat[2][2] = 1.0;
        return result;
    }

    public String toString() {
        return VecOp.toString(this);
    }

    @Override
    public int getNRows() {
        return 3;
    }

    @Override
    public int getNColumns() {
        return 3;
    }

    @Override
    public void invert() throws MatrixOp.IndeterminateMatrixException {
        MatrixOp.inverse(this, this);
    }

    @Override
    public void transpose() {
        double t = this.m_dmat[0][1];
        this.m_dmat[0][1] = this.m_dmat[1][0];
        this.m_dmat[1][0] = t;
        t = this.m_dmat[0][2];
        this.m_dmat[0][2] = this.m_dmat[2][0];
        this.m_dmat[2][0] = t;
        t = this.m_dmat[1][2];
        this.m_dmat[1][2] = this.m_dmat[2][1];
        this.m_dmat[2][1] = t;
    }
}

