/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.jet;

import hep.physics.filter.Predicate;
import hep.physics.jet.AbstractJetFinder;
import hep.physics.jet.JadeEJetFinder;
import hep.physics.jet.JetFinder;
import hep.physics.vec.HepLorentzVector;
import java.util.Collection;
import java.util.List;

public class FixNumberOfJetsFinder
implements JetFinder {
    private AbstractJetFinder m_jetFinder = new JadeEJetFinder(0.01);
    private int m_nReqJets = 2;
    private double m_ycut = -1.0;
    private boolean m_resultsValid = false;

    public FixNumberOfJetsFinder() {
    }

    public FixNumberOfJetsFinder(int nJets) {
        this.setNJets(nJets);
    }

    public FixNumberOfJetsFinder(AbstractJetFinder jetFinder) {
        this.setJetFinder(jetFinder);
    }

    public FixNumberOfJetsFinder(int nJets, AbstractJetFinder jetFinder) {
        this.setJetFinder(jetFinder);
        this.setNJets(nJets);
    }

    protected void setJetFinder(AbstractJetFinder jetFinder) {
        if (jetFinder == null) {
            throw new IllegalArgumentException("FixNumberOfJetsFinder: no JetFinder defined!");
        }
        this.m_jetFinder = jetFinder;
        this.m_resultsValid = false;
    }

    public void setNJets(int nJets) {
        if (nJets != this.m_nReqJets) {
            this.m_resultsValid = false;
        }
        this.m_nReqJets = nJets;
    }

    @Override
    public int njets() {
        if (!this.m_resultsValid) {
            this.doFindJets();
        }
        return this.m_jetFinder.njets();
    }

    public double getYCut() {
        if (!this.m_resultsValid) {
            this.doFindJets();
        }
        return this.m_ycut;
    }

    @Override
    public HepLorentzVector jet(int index) {
        if (!this.m_resultsValid) {
            this.doFindJets();
        }
        return this.m_jetFinder.jet(index);
    }

    @Override
    public List particlesInJet(int index) {
        if (!this.m_resultsValid) {
            this.doFindJets();
        }
        return this.m_jetFinder.particlesInJet(index);
    }

    @Override
    public int nParticlesPerJet(int index) {
        if (!this.m_resultsValid) {
            this.doFindJets();
        }
        return this.m_jetFinder.nParticlesPerJet(index);
    }

    @Override
    public int fewestTracks() {
        if (!this.m_resultsValid) {
            this.doFindJets();
        }
        return this.m_jetFinder.fewestTracks();
    }

    @Override
    public void setEvent(Collection data) {
        this.setEvent(data, null);
    }

    @Override
    public void setEvent(Collection data, Predicate cut) {
        this.m_resultsValid = false;
        this.m_jetFinder.setEvent(data, cut);
    }

    private void doFindJets() {
        double ycut = 0.5;
        int njets = -1;
        double yHigh = 0.999999;
        double yLow = 1.0E-6;
        while (njets != this.m_nReqJets) {
            ycut = 0.5 * (yLow + yHigh);
            this.m_jetFinder.setYCut(ycut);
            njets = this.m_jetFinder.njets();
            if (Math.abs(yHigh - yLow) < 1.0E-10) {
                throw new NumJetsNotFoundException("JetFinder:  Can not find " + this.m_nReqJets + " !");
            }
            if (njets > this.m_nReqJets) {
                yLow = ycut;
            }
            if (njets >= this.m_nReqJets) continue;
            yHigh = ycut;
        }
        this.m_ycut = ycut;
        this.m_resultsValid = true;
    }

    public static class NumJetsNotFoundException
    extends RuntimeException {
        public NumJetsNotFoundException(String s) {
            super(s);
        }
    }
}

