/*
 * Decompiled with CFR 0.152.
 */
package hep.physics.event;

import hep.physics.event.HEPEvent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BaseEvent
implements HEPEvent {
    private int run;
    private int event;
    private long timestamp;
    private Map keyMap = new HashMap();
    private Map tagMap;

    public BaseEvent(int run, int event) {
        this(run, event, System.currentTimeMillis() * 1000000L);
    }

    public BaseEvent(int run, int event, long timestamp) {
        this.run = run;
        this.event = event;
        this.timestamp = timestamp;
    }

    @Override
    public Object get(String key) {
        Object result = this.keyMap.get(key);
        if (result == null) {
            throw new IllegalArgumentException("Unknown event component " + key);
        }
        return result;
    }

    @Override
    public int getEventNumber() {
        return this.event;
    }

    @Override
    public int getRunNumber() {
        return this.run;
    }

    @Override
    public Map getTags() {
        return this.tagMap == null ? Collections.EMPTY_MAP : this.tagMap;
    }

    @Override
    public Set keys() {
        return this.keyMap.keySet();
    }

    @Override
    public void put(String key, Object component) {
        this.keyMap.put(key, component);
    }

    @Override
    public long getTimeStamp() {
        return this.timestamp;
    }
}

