/*
 * Decompiled with CFR 0.152.
 */
package hep.io.stdhep;

import hep.io.mcfio.MCFIOBlock;
import hep.io.mcfio.MCFIOEvent;
import hep.io.mcfio.MCFIOWriter;
import hep.io.stdhep.StdhepConstants;
import hep.io.stdhep.StdhepEvent;
import hep.io.stdhep.StdhepRecord;
import java.io.IOException;

public class StdhepWriter
extends MCFIOWriter
implements StdhepConstants {
    private static int[] blockIds = new int[]{101, 105, 106, 107};
    private static String[] blockNames = new String[]{"Stdhep Event", "Stdhep Multi", "Stdhep Begin Run", "Stdhep End Run"};
    private MCFIOEventWrapper event = new MCFIOEventWrapper();

    public StdhepWriter(String file, String title, String comment, int numevts) throws IOException {
        super(file, title, comment, numevts, blockIds, blockNames);
    }

    public void writeRecord(StdhepRecord record) throws IOException {
        if (compatibilityMode && record instanceof StdhepEvent && ((StdhepEvent)record).getNHEP() > 4000) {
            throw new IOException("Too many particles");
        }
        this.event.setRecord(record);
        this.write(this.event);
    }

    private class MCFIOEventWrapper
    implements MCFIOEvent {
        private StdhepRecord record;

        private MCFIOEventWrapper() {
        }

        @Override
        public MCFIOBlock getBlock(int index) {
            return this.record;
        }

        @Override
        public int getBlockID(int index) {
            return this.record.getID();
        }

        @Override
        public int getEventNumber() {
            if (this.record instanceof StdhepEvent) {
                return ((StdhepEvent)this.record).getNEVHEP();
            }
            return 0;
        }

        @Override
        public int getNBlocks() {
            return 1;
        }

        @Override
        public int getRunNumber() {
            return 0;
        }

        @Override
        public int getStoreNumber() {
            return 0;
        }

        @Override
        public int getTrigMask() {
            return 0;
        }

        void setRecord(StdhepRecord record) throws IOException {
            this.record = record;
        }
    }
}

