/*
 * Decompiled with CFR 0.152.
 */
package hep.io.stdhep;

import hep.io.stdhep.StdhepRecord;
import hep.io.xdr.XDRDataInput;
import hep.io.xdr.XDRDataOutput;
import java.io.IOException;

public class StdhepEvent
extends StdhepRecord {
    private int[] idhep;
    private int[] isthep;
    private int[] jdahep;
    private int[] jmohep;
    private double[] phep;
    private double[] vhep;
    private int nevhep;
    private int nhep;

    public StdhepEvent(int nevhep, int nhep, int[] isthep, int[] idhep, int[] jmohep, int[] jdahep, double[] phep, double[] vhep) {
        this(101, nevhep, nhep, isthep, idhep, jmohep, jdahep, phep, vhep);
    }

    StdhepEvent(int id, int nevhep, int nhep, int[] isthep, int[] idhep, int[] jmohep, int[] jdahep, double[] phep, double[] vhep) {
        super(id);
        this.version = "5.04";
        this.length = 4 * (12 + 24 * nhep);
        this.nevhep = nevhep;
        this.nhep = nhep;
        this.isthep = isthep;
        this.idhep = idhep;
        this.jmohep = jmohep;
        this.jdahep = jdahep;
        this.phep = phep;
        this.vhep = vhep;
    }

    StdhepEvent() {
        this(101);
    }

    StdhepEvent(int id) {
        super(id);
    }

    public int getIDHEP(int index) {
        return this.idhep[index];
    }

    public int getISTHEP(int index) {
        return this.isthep[index];
    }

    public int getJDAHEP(int index, int i) {
        return this.jdahep[index * 2 + i];
    }

    public int getJMOHEP(int index, int i) {
        return this.jmohep[index * 2 + i];
    }

    public int getNEVHEP() {
        return this.nevhep;
    }

    public int getNHEP() {
        return this.nhep;
    }

    public double getPHEP(int index, int i) {
        return this.phep[index * 5 + i];
    }

    public double getVHEP(int index, int i) {
        return this.vhep[index * 4 + i];
    }

    @Override
    public void read(XDRDataInput xdr) throws IOException {
        super.read(xdr);
        this.nevhep = xdr.readInt();
        this.nhep = xdr.readInt();
        this.isthep = xdr.readIntArray(this.isthep);
        this.idhep = xdr.readIntArray(this.idhep);
        this.jmohep = xdr.readIntArray(this.jmohep);
        this.jdahep = xdr.readIntArray(this.jdahep);
        this.phep = xdr.readDoubleArray(this.phep);
        this.vhep = xdr.readDoubleArray(this.vhep);
    }

    public String toString() {
        return "Event " + this.nevhep + " particles=" + this.nhep;
    }

    @Override
    public void write(XDRDataOutput xdr) throws IOException {
        super.write(xdr);
        xdr.writeInt(this.nevhep);
        xdr.writeInt(this.nhep);
        xdr.writeIntArray(this.isthep, 0, this.nhep);
        xdr.writeIntArray(this.idhep, 0, this.nhep);
        xdr.writeIntArray(this.jmohep, 0, 2 * this.nhep);
        xdr.writeIntArray(this.jdahep, 0, 2 * this.nhep);
        xdr.writeDoubleArray(this.phep, 0, 5 * this.nhep);
        xdr.writeDoubleArray(this.vhep, 0, 4 * this.nhep);
    }
}

