/*
 * Decompiled with CFR 0.152.
 */
package hep.io.sio;

import hep.io.sio.SIOOutputStream;
import hep.io.xdr.XDRBufferedRandomAccessFile;
import hep.io.xdr.XDRDataOutput;
import hep.io.xdr.XDROutputStream;
import hep.io.xdr.XDRRandomAccessFile;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

public class SIOWriter
implements Closeable,
Flushable {
    private XDRDataOutput xdr;
    private SIOByteArrayOutputStream blockBytes = new SIOByteArrayOutputStream();
    private SIOByteArrayOutputStream recordBytes = new SIOByteArrayOutputStream();
    private SIOOutputStream block = new SIOOutputStream(this.blockBytes);
    private XDROutputStream record = new XDROutputStream(this.recordBytes);
    private DeflaterOutputStream compressor;
    private static final int recordFrame = -1414673666;
    private static final int blockFrame = -559038737;
    private String blockName;
    private int blockVersion;
    private String recordName;
    private boolean recordCompress = false;
    private static int bufferSize = Integer.getInteger("hep.io.sio.BufferSize", 32768);
    private int originalLength;
    private long originalPosition;

    public SIOWriter(OutputStream out) throws IOException {
        this.xdr = new XDROutputStream(out);
    }

    public SIOWriter(String file) throws IOException {
        this.xdr = new XDRBufferedRandomAccessFile(file, false, bufferSize);
    }

    public SIOWriter(File file) throws IOException {
        this.xdr = new XDRBufferedRandomAccessFile(file, false, bufferSize);
    }

    public long createRecord(String name, boolean compress) throws IOException {
        this.flushRecord();
        this.prepareRecord(name, compress);
        return this.getPosition();
    }

    public void rewriteRecord(long position, boolean compress) throws IOException {
        this.flushRecord();
        XDRRandomAccessFile raf = this.checkRandomAccess();
        this.originalPosition = raf.getFilePointer();
        raf.seek(position);
        int headerLength = raf.readInt();
        int frame = raf.readInt();
        if (frame != -1414673666) {
            throw new IOException("Framing error");
        }
        int control = raf.readInt();
        if ((control & 0xFFFC) != 0) {
            throw new IOException("Bad control word");
        }
        int compressedLength = raf.readInt();
        int uncompressedLength = raf.readInt();
        int l = raf.readInt();
        if ((long)l > (long)headerLength - raf.getFilePointer() + this.originalPosition) {
            throw new IOException("Record name is insane");
        }
        String originalName = raf.readString(l);
        this.originalLength = compressedLength;
        this.prepareRecord(originalName, compress);
        raf.seek(position);
    }

    public long reserveSpaceForRecord(String name, int size) throws IOException {
        this.flushRecord();
        XDRRandomAccessFile raf = this.checkRandomAccess();
        long recordPosition = raf.getFilePointer();
        this.writeRecordHeader(name, 2, size, size);
        raf.seek(raf.getFilePointer() + (long)size);
        this.xdr.pad();
        return recordPosition;
    }

    public SIOOutputStream createBlock(String name, int major, int minor) throws IOException {
        if (this.recordName == null) {
            throw new IOException("No record currently exists");
        }
        this.flushBlock();
        this.blockName = name;
        this.blockVersion = (major << 16) + minor;
        return this.block;
    }

    private void flushBlock() throws IOException {
        if (this.blockName == null) {
            return;
        }
        this.block.flush();
        int blockLength = this.pad(this.blockBytes.size()) + 16 + this.pad(this.blockName.length());
        this.record.writeInt(blockLength);
        this.record.writeInt(-559038737);
        this.record.writeInt(this.blockVersion);
        this.record.writeString(this.blockName);
        this.blockBytes.writeTo(this.record);
        this.blockBytes.reset();
        this.blockName = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushRecord() throws IOException {
        if (this.recordName == null) {
            return;
        }
        try {
            this.flushBlock();
            this.block.clear();
            this.record.flush();
            if (this.recordCompress) {
                this.compressor.finish();
            }
            if (this.originalPosition != 0L && this.recordBytes.size() > this.originalLength) {
                throw new IOException("Rewritten record does not fit");
            }
            this.writeRecordHeader(this.recordName, this.recordCompress ? 1 : 0, this.originalPosition != 0L ? this.originalLength : this.recordBytes.size(), (int)this.record.getBytesWritten());
            this.recordBytes.writeTo(this.xdr);
            this.recordBytes.reset();
            this.xdr.pad();
        }
        finally {
            this.recordName = null;
            if (this.originalPosition != 0L) {
                this.checkRandomAccess().seek(this.originalPosition);
                this.originalPosition = 0L;
                this.originalLength = 0;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.flushRecord();
        if (this.xdr instanceof XDRRandomAccessFile) {
            XDRRandomAccessFile raf = (XDRRandomAccessFile)this.xdr;
            raf.setLength(raf.getFilePointer());
        }
        this.xdr.close();
    }

    @Override
    public void flush() throws IOException {
        this.flushRecord();
        this.xdr.flush();
    }

    public boolean isRandomAccess() {
        return this.xdr instanceof XDRRandomAccessFile;
    }

    private XDRRandomAccessFile checkRandomAccess() throws IOException {
        if (!this.isRandomAccess()) {
            throw new IOException("File does not support random access");
        }
        return (XDRRandomAccessFile)this.xdr;
    }

    private long getPosition() throws IOException {
        if (this.xdr instanceof XDRRandomAccessFile) {
            return ((XDRRandomAccessFile)this.xdr).getFilePointer();
        }
        return ((XDROutputStream)this.xdr).getBytesWritten();
    }

    private int pad(int size) {
        int r = size % 4;
        if (r == 0) {
            return size;
        }
        return size + 4 - r;
    }

    private void prepareRecord(String name, boolean compress) {
        this.recordName = name;
        if (compress) {
            this.compressor = new DeflaterOutputStream(this.recordBytes);
            this.record = new XDROutputStream(this.compressor);
        } else {
            this.compressor = null;
            this.record = new XDROutputStream(this.recordBytes);
        }
        this.recordCompress = compress;
    }

    private void writeRecordHeader(String name, int mode, int compressedSize, int uncompressedSize) throws IOException {
        int headerLength = 24 + this.pad(name.length());
        this.xdr.writeInt(headerLength);
        this.xdr.writeInt(-1414673666);
        this.xdr.writeInt(mode);
        this.xdr.writeInt(compressedSize);
        this.xdr.writeInt(uncompressedSize);
        this.xdr.writeString(name);
        this.xdr.pad();
    }

    private static class SIOByteArrayOutputStream
    extends ByteArrayOutputStream {
        private SIOByteArrayOutputStream() {
        }

        void writeTo(DataOutput out) throws IOException {
            out.write(this.buf, 0, this.count);
        }
    }
}

