/*
 * Decompiled with CFR 0.152.
 */
package hep.io.sio;

import hep.io.sio.SIOBlock;
import hep.io.sio.SIOInputStream;
import hep.io.sio.SIORecord;
import hep.io.xdr.XDRBufferedRandomAccessFile;
import hep.io.xdr.XDRDataInput;
import hep.io.xdr.XDRInputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.zip.InflaterInputStream;

public class SIOReader
implements Closeable {
    private XDRDataInput xdr;
    private SIORecordImpl currentRecord;
    private long nextRecordPosition;
    private static int bufferSize = Integer.getInteger("hep.io.sio.BufferSize", 32768);

    public SIOReader(InputStream in) throws IOException {
        XDRInputStream sio = new XDRInputStream(in);
        this.xdr = sio;
        this.currentRecord = new SIORecordImpl(sio);
    }

    public SIOReader(File file) throws IOException {
        XDRBufferedRandomAccessFile raf = new XDRBufferedRandomAccessFile(file, true, bufferSize);
        this.xdr = raf;
        this.currentRecord = new SIORecordImpl(raf);
    }

    public SIOReader(String file) throws IOException {
        XDRBufferedRandomAccessFile raf = new XDRBufferedRandomAccessFile(file, true, bufferSize);
        this.xdr = raf;
        this.currentRecord = new SIORecordImpl(raf);
    }

    public boolean isRandomAccess() {
        return this.xdr instanceof RandomAccessFile;
    }

    public SIORecord readRecord() throws IOException {
        this.nextRecordPosition = this.currentRecord.nextRecord();
        return this.currentRecord;
    }

    public SIORecord readRecord(long position) throws IOException {
        this.seek(position);
        return this.readRecord();
    }

    public void seek(long position) throws IOException {
        RandomAccessFile raf = this.checkRandomAccess();
        if (position >= 0L) {
            raf.seek(position);
        } else {
            raf.seek(raf.length() + position);
        }
        this.currentRecord.clear();
        this.nextRecordPosition = position;
    }

    public long getNextRecordPosition() throws IOException {
        return this.nextRecordPosition;
    }

    @Override
    public void close() throws IOException {
        this.xdr.close();
    }

    private RandomAccessFile checkRandomAccess() throws IOException {
        if (!this.isRandomAccess()) {
            throw new IOException("File does not support random access");
        }
        return (RandomAccessFile)((Object)this.xdr);
    }

    private static class RandomAccessFileInputStream
    extends InputStream {
        private RandomAccessFile file;
        private int readLimit;

        public RandomAccessFileInputStream(RandomAccessFile file, int readLimit) {
            this.file = file;
            this.readLimit = readLimit;
        }

        @Override
        public int read() throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            int c = this.file.read();
            --this.readLimit;
            return c;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.available() == 0) {
                throw new EOFException();
            }
            int n = this.file.read(b, off, Math.min(len, this.available()));
            this.readLimit -= n;
            return n;
        }

        @Override
        public long skip(long n) throws IOException {
            long pos = this.file.getFilePointer();
            long nActual = Math.min(n, (long)this.available());
            this.file.seek(pos + nActual);
            this.readLimit = (int)((long)this.readLimit - nActual);
            return nActual;
        }

        @Override
        public int available() throws IOException {
            return (int)Math.min((long)this.readLimit, this.file.length() - this.file.getFilePointer());
        }

        @Override
        public void close() throws IOException {
            this.file.close();
        }
    }

    private static class SIOBlockImpl
    implements SIOBlock {
        private String name;
        private int recordLength;
        private int length;
        private int version;
        private SIOInputStream xdr;
        private long startPos;
        private long recordStartPos;
        private static final EOFException eof = new EOFException();

        SIOBlockImpl(SIOInputStream xdr, int recordLength) throws IOException {
            this.xdr = xdr;
            this.recordLength = recordLength;
            this.length = 0;
            this.recordStartPos = this.startPos = xdr.getBytesRead();
        }

        void nextBlock() throws IOException {
            this.xdr.clearReadLimit();
            int bytesLeft = this.length - (int)(this.xdr.getBytesRead() - this.startPos);
            if (bytesLeft < 0) {
                throw new IOException("Block overrun error (block " + this.name + ")");
            }
            if (bytesLeft > 0) {
                this.xdr.skipBytes(bytesLeft);
            }
            this.xdr.pad();
            this.startPos = this.xdr.getBytesRead();
            if (this.startPos - this.recordStartPos >= (long)this.recordLength) {
                throw eof;
            }
            this.length = this.xdr.readInt();
            this.xdr.setReadLimit(this.length - 4);
            int frame = this.xdr.readInt();
            if (frame != -559038737) {
                throw new IOException("Block framing error");
            }
            this.version = this.xdr.readInt();
            int l = this.xdr.readInt();
            if ((long)l > (long)this.length - this.xdr.getBytesRead() + this.startPos) {
                throw new IOException("Block name is insane");
            }
            this.name = this.xdr.readString(l);
        }

        @Override
        public String getBlockName() {
            return this.name;
        }

        @Override
        public int getBlockLength() {
            return this.length;
        }

        @Override
        public int getBytesLeft() {
            return this.length - (int)(this.xdr.getBytesRead() - this.startPos);
        }

        @Override
        public int getVersion() {
            return this.version;
        }

        @Override
        public int getMajorVersion() {
            return (this.version & 0xFFFF0000) >> 16;
        }

        @Override
        public int getMinorVersion() {
            return this.version & 0xFFFF;
        }

        @Override
        public SIOInputStream getData() {
            return this.xdr;
        }
    }

    private static class SIORecordImpl
    implements SIORecord {
        private SIOBlockImpl currentBlock;
        private String name;
        private int headerLength;
        private int compressedLength;
        private int uncompressedLength;
        private boolean blocksRead = true;
        private boolean compressed;
        private long startPos;
        private XDRDataInput xdr;

        SIORecordImpl(XDRDataInput xdr) throws IOException {
            this.xdr = xdr;
        }

        private void clear() {
            this.blocksRead = false;
            this.compressedLength = 0;
            this.currentBlock = null;
        }

        long nextRecord() throws IOException {
            this.skipRemainderOfRecord();
            this.readRecordHeader();
            this.startPos = this.getPosition();
            return this.startPos + (long)this.pad(this.compressedLength);
        }

        private int pad(int size) {
            int r = size % 4;
            if (r == 0) {
                return size;
            }
            return size + 4 - r;
        }

        @Override
        public String getRecordName() {
            return this.name;
        }

        @Override
        public int getRecordLength() {
            return this.uncompressedLength;
        }

        @Override
        public SIOBlock getBlock() throws IOException {
            if (this.currentBlock == null) {
                if (!this.compressed) {
                    if (this.xdr instanceof XDRInputStream) {
                        ((XDRInputStream)this.xdr).clearReadLimit();
                    }
                    this.currentBlock = new SIOBlockImpl(new SIOInputStream(this.getInputStream(this.compressedLength)), this.compressedLength);
                } else {
                    this.currentBlock = new SIOBlockImpl(new SIOInputStream(new InflaterInputStream(this.getInputStream(this.compressedLength))), this.uncompressedLength);
                }
                this.blocksRead = true;
            }
            try {
                this.currentBlock.nextBlock();
                return this.currentBlock;
            }
            catch (EOFException x) {
                return null;
            }
        }

        private InputStream getInputStream(int readLimit) {
            if (this.xdr instanceof RandomAccessFile) {
                return new RandomAccessFileInputStream((RandomAccessFile)((Object)this.xdr), readLimit);
            }
            ((XDRInputStream)this.xdr).setReadLimit(readLimit);
            return (XDRInputStream)this.xdr;
        }

        private long getPosition() throws IOException {
            if (this.xdr instanceof RandomAccessFile) {
                return ((RandomAccessFile)((Object)this.xdr)).getFilePointer();
            }
            return ((XDRInputStream)this.xdr).getBytesRead();
        }

        private void readRecordHeader() throws IOException {
            long headerStart = this.getPosition();
            this.headerLength = this.xdr.readInt();
            int frame = this.xdr.readInt();
            if (frame != -1414673666) {
                throw new IOException("Framing error");
            }
            int control = this.xdr.readInt();
            if ((control & 0xFFFE) != 0) {
                throw new IOException("Bad control word");
            }
            this.compressed = (control & 1) != 0;
            this.compressedLength = this.xdr.readInt();
            this.uncompressedLength = this.xdr.readInt();
            int l = this.xdr.readInt();
            if ((long)l > (long)this.headerLength - this.getPosition() + headerStart) {
                throw new IOException("Record name is insane");
            }
            this.name = this.xdr.readString(l);
            this.blocksRead = false;
            this.currentBlock = null;
        }

        private void skipRemainderOfRecord() throws IOException {
            if (this.xdr instanceof XDRInputStream) {
                ((XDRInputStream)this.xdr).clearReadLimit();
            }
            if (!this.blocksRead) {
                this.xdr.skipBytes(this.compressedLength);
            } else {
                int left = this.compressedLength - (int)(this.getPosition() - this.startPos);
                if (left < 0) {
                    throw new IOException("Record overrun error");
                }
                this.xdr.skipBytes(left);
            }
            this.xdr.pad();
        }
    }
}

