/*
 * Decompiled with CFR 0.152.
 */
package hep.io.mcfio;

import hep.io.mcfio.EventTable;
import hep.io.mcfio.FileHeader;
import hep.io.mcfio.MCFIOConstants;
import hep.io.mcfio.MCFIOEvent;
import hep.io.mcfio.MCFIOException;
import hep.io.xdr.XDRBufferedRandomAccessFile;
import hep.io.xdr.XDRRandomAccessFile;
import java.io.IOException;

public class MCFIOWriter
implements MCFIOConstants {
    protected static boolean compatibilityMode = true;
    private FileHeader fileHeader;
    private WriteEventTable eventTable;
    private XDRRandomAccessFile xdr;

    public MCFIOWriter(String file, String title, String comment, int numevts, int[] blockIds, String[] blockNames) throws IOException {
        if (compatibilityMode) {
            if (title.length() > 255) {
                throw new MCFIOException("Title too long");
            }
            if (comment.length() > 255) {
                throw new MCFIOException("Comment too long");
            }
        }
        this.xdr = new XDRBufferedRandomAccessFile(file, false, 16192);
        this.fileHeader = new FileHeader(this.getPosition(), title, comment, numevts, blockIds, blockNames);
        this.xdr.seek(this.fileHeader.getLength());
        this.fileHeader.setFirstTable(this.getPosition());
        this.eventTable = new WriteEventTable(this.getPosition());
        this.xdr.seek(this.getPosition() + this.eventTable.getLength());
    }

    public void setCompatibilityMode(boolean mode) {
        compatibilityMode = mode;
    }

    public void close() throws IOException {
        this.eventTable.commit(this.xdr);
        this.fileHeader.commit(this.xdr);
        this.xdr.close();
    }

    public void write(MCFIOEvent event) throws IOException {
        if (this.eventTable.isFull()) {
            this.eventTable = this.eventTable.newTable();
        }
        this.eventTable.add(event);
    }

    private int getPosition() throws IOException {
        return (int)this.xdr.getFilePointer();
    }

    private class WriteEventTable
    extends EventTable {
        WriteEventTable(int pos) throws IOException {
            super(pos);
        }

        void add(MCFIOEvent event) throws IOException {
            int i;
            super.add(event, MCFIOWriter.this.getPosition());
            int nBlocks = event.getNBlocks();
            int size = 4 * (12 + nBlocks * 2);
            MCFIOWriter.this.xdr.writeInt(4);
            MCFIOWriter.this.xdr.writeInt(size);
            MCFIOWriter.this.xdr.writeString("1.00");
            MCFIOWriter.this.xdr.writeInt(event.getEventNumber());
            MCFIOWriter.this.xdr.writeInt(event.getStoreNumber());
            MCFIOWriter.this.xdr.writeInt(event.getRunNumber());
            MCFIOWriter.this.xdr.writeInt(event.getTrigMask());
            MCFIOWriter.this.xdr.writeInt(nBlocks);
            MCFIOWriter.this.xdr.writeInt(nBlocks);
            int[] ptrs = new int[nBlocks];
            int[] ids = new int[nBlocks];
            int pos = MCFIOWriter.this.getPosition() + 4 * (2 + nBlocks * 2);
            for (i = 0; i < nBlocks; ++i) {
                ids[i] = event.getBlockID(i);
                ptrs[i] = pos;
                pos += event.getBlock(i).getLength();
            }
            MCFIOWriter.this.xdr.writeIntArray(ids);
            MCFIOWriter.this.xdr.writeIntArray(ptrs);
            for (i = 0; i < nBlocks; ++i) {
                event.getBlock(i).write(MCFIOWriter.this.xdr);
            }
        }

        @Override
        void commit(XDRRandomAccessFile xdr) throws IOException {
            MCFIOWriter.this.fileHeader.incrementNumEvents(this.numevts());
            super.commit(xdr);
        }

        WriteEventTable newTable() throws IOException {
            int currentPos = MCFIOWriter.this.getPosition();
            this.setNextTable(currentPos);
            this.commit(MCFIOWriter.this.xdr);
            MCFIOWriter.this.xdr.seek(currentPos + this.getLength());
            return new WriteEventTable(currentPos);
        }
    }
}

