/*
 * Decompiled with CFR 0.152.
 */
package hep.io.mcfio;

import hep.io.mcfio.MCFIOBlock;
import hep.io.mcfio.MCFIOConstants;
import hep.io.mcfio.MCFIOException;
import hep.io.xdr.XDRDataInput;
import hep.io.xdr.XDRDataOutput;
import hep.io.xdr.XDRRandomAccessFile;
import java.io.IOException;
import java.util.Date;

class FileHeader
extends MCFIOBlock
implements MCFIOConstants {
    private String closingDate;
    private String comment;
    private String date;
    private String title;
    private int[] blockIds;
    private String[] blockNames;
    private int firsttable;
    private int location;
    private int numevts;
    private int numevts_expect;

    FileHeader() throws IOException {
        super(1);
    }

    FileHeader(int pos, String title, String comment, int numevts, int[] blockIds, String[] blockNames) throws IOException {
        super(1);
        this.version = "1.00";
        if (blockIds.length != blockNames.length) {
            throw new IllegalArgumentException("Inconsistent length got blockIds,blockNames");
        }
        this.location = pos;
        this.title = title;
        this.comment = comment;
        this.numevts_expect = numevts;
        this.numevts = 0;
        this.date = new Date().toString();
        this.blockIds = blockIds;
        this.blockNames = blockNames;
    }

    @Override
    public void read(XDRDataInput xdr) throws IOException {
        int nTuples;
        super.read(xdr);
        if (this.fVersion > 2.01) {
            throw new MCFIOException("Unsupported version " + this.version + " for FileHeader");
        }
        this.title = xdr.readString();
        this.comment = xdr.readString();
        this.date = xdr.readString();
        this.closingDate = this.fVersion <= 2.0 ? this.date : xdr.readString();
        this.numevts_expect = xdr.readInt();
        this.numevts = xdr.readInt();
        this.firsttable = xdr.readInt();
        int dimTable = xdr.readInt();
        int nBlocks = xdr.readInt();
        int n = nTuples = this.fVersion >= 2.0 ? xdr.readInt() : 0;
        if (nTuples > 0) {
            throw new IOException("NTuples not supported");
        }
        this.blockIds = xdr.readIntArray(this.blockIds);
        this.blockNames = new String[nBlocks];
        for (int i = 0; i < nBlocks; ++i) {
            this.blockNames[i] = xdr.readString();
        }
    }

    @Override
    public void write(XDRDataOutput xdr) throws IOException {
        super.write(xdr);
        xdr.writeString(this.title);
        xdr.writeString(this.comment);
        xdr.writeString(this.date);
        xdr.writeInt(this.numevts_expect);
        xdr.writeInt(this.numevts);
        xdr.writeInt(this.firsttable);
        xdr.writeInt(100);
        xdr.writeInt(this.blockIds.length);
        xdr.writeIntArray(this.blockIds);
        for (int i = 0; i < this.blockIds.length; ++i) {
            xdr.writeString(this.blockNames[i]);
        }
    }

    @Override
    protected int getLength() {
        int l = 4 * (10 + this.blockIds.length);
        l += this.strlen(this.title);
        l += this.strlen(this.comment);
        l += this.strlen(this.date);
        for (int i = 0; i < this.blockNames.length; ++i) {
            l += this.strlen(this.blockNames[i]);
        }
        return l;
    }

    String getComment() {
        return this.comment;
    }

    String getDate() {
        return this.date;
    }

    void setFirstTable(int pos) {
        this.firsttable = pos;
    }

    int getFirstTable() {
        return this.firsttable;
    }

    int getNumberOfEvents() {
        return this.numevts;
    }

    int getNumberOfEventsExpected() {
        return this.numevts_expect;
    }

    String getTitle() {
        return this.title;
    }

    void commit(XDRRandomAccessFile xdr) throws IOException {
        long pos = xdr.getFilePointer();
        xdr.seek(this.location);
        this.write(xdr);
        xdr.seek(pos);
    }

    void incrementNumEvents(int n) {
        this.numevts += n;
    }

    private int strlen(String s) {
        int l = s.length();
        if (l % 4 != 0) {
            l += 4 - l % 4;
        }
        return l + 4;
    }
}

