/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep1.ref;

import hep.graphics.heprep1.HepRepAttDef;
import hep.graphics.heprep1.HepRepAttValue;
import hep.graphics.heprep1.HepRepAttribute;
import hep.graphics.heprep1.HepRepInstance;
import hep.graphics.heprep1.HepRepPoint;
import hep.graphics.heprep1.HepRepPrimitive;
import hep.graphics.heprep1.HepRepType;
import hep.graphics.heprep1.ref.DefaultHepRepAttDef;
import hep.graphics.heprep1.ref.DefaultHepRepAttValue;
import hep.graphics.heprep1.ref.HepRepDefaults;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class DefaultHepRepAttribute
implements HepRepAttribute,
Serializable {
    private HepRepAttribute parent;
    private Hashtable attVals;
    private Hashtable attDefs;
    public static EmptyEnumeration empty = new EmptyEnumeration();

    public DefaultHepRepAttribute(HepRepAttribute parent) {
        this.parent = parent;
    }

    @Override
    public HepRepAttribute getParent() {
        return this.parent;
    }

    @Override
    public Enumeration getAttValues() {
        return this.attVals == null ? empty : this.attVals.elements();
    }

    @Override
    public Enumeration getAttDefs() {
        return this.attDefs == null ? empty : this.attDefs.elements();
    }

    @Override
    public HepRepAttDef getAttDef(String name) {
        HepRepAttribute table = this;
        HepRepAttDef def = null;
        while ((def = table.getAttDefFromNode(name)) == null && table.getParent() != null) {
            table = table.getParent();
        }
        return def;
    }

    @Override
    public HepRepAttValue getAttValue(String name) {
        HepRepAttribute table = this;
        HepRepAttValue val = null;
        while ((val = table.getAttValueFromNode(name)) == null && table.getParent() != null) {
            table = table.getParent();
        }
        return val;
    }

    @Override
    public void addValue(String key, String value) {
        this.addValue(key, value, 0);
    }

    @Override
    public void addValue(String key, int value, int showLabel) {
        this.addValue(key, Integer.toString(value), showLabel);
    }

    @Override
    public void addValue(String key, double value, int showLabel) {
        this.addValue(key, Double.toString(value), showLabel);
    }

    @Override
    public void addValue(String key, boolean value, int showLabel) {
        this.addValue(key, value ? "true" : "false", showLabel);
    }

    @Override
    public void addValue(String key, String value, int showLabel) {
        if (this.attVals == null) {
            this.attVals = new Hashtable();
        }
        this.attVals.put(key.toLowerCase(), new DefaultHepRepAttValue(key, value, showLabel));
    }

    @Override
    public void addColor(String key, String colorName, int showLabel) {
        this.addValue(key, colorName, showLabel);
    }

    @Override
    public void addColor(String key, double r, double g, double b, double alpha, int showLabel) {
        this.addColor(key, r + ", " + g + ", " + b + ", " + alpha, showLabel);
    }

    @Override
    public void addDefinition(String name, String desc, String type, String extra) {
        if (this.attDefs == null) {
            this.attDefs = new Hashtable();
        }
        this.attDefs.put(name.toLowerCase(), new DefaultHepRepAttDef(name, desc, type, extra));
    }

    @Override
    public HepRepAttDef getAttDefFromNode(String name) {
        return this.attDefs == null ? null : (HepRepAttDef)this.attDefs.get(name.toLowerCase());
    }

    @Override
    public HepRepAttValue getAttValueFromNode(String name) {
        HepRepAttValue value = null;
        if (this.attVals != null) {
            value = (HepRepAttValue)this.attVals.get(name.toLowerCase());
        }
        if (value == null && this.getParent() == null) {
            value = HepRepDefaults.getAttValue(name.toLowerCase());
        }
        return value;
    }

    public void add(HepRepPoint arg) {
        throw new IllegalArgumentException("Cannot add: " + arg.getClass().toString() + " to node: " + this.getClass().toString());
    }

    public void add(HepRepPrimitive arg) {
        throw new IllegalArgumentException("Cannot add: " + arg.getClass().toString() + " to node: " + this.getClass().toString());
    }

    public void add(HepRepInstance arg) {
        throw new IllegalArgumentException("Cannot add: " + arg.getClass().toString() + " to node: " + this.getClass().toString());
    }

    public void add(HepRepType arg) {
        throw new IllegalArgumentException("Cannot add: " + arg.getClass().toString() + " to node: " + this.getClass().toString());
    }

    static class EmptyEnumeration
    implements Enumeration {
        EmptyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    }
}

