/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep1.adapter;

import hep.graphics.heprep.HepRepAttValue;
import hep.graphics.heprep.HepRepInstance;
import hep.graphics.heprep.HepRepInstanceTree;
import hep.graphics.heprep.HepRepPoint;
import hep.graphics.heprep.HepRepSelectFilter;
import hep.graphics.heprep.HepRepType;
import hep.graphics.heprep.HepRepTypeTree;
import hep.graphics.heprep1.HepRepAttribute;
import hep.graphics.heprep1.adapter.HepRepAttributeAdapter;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractHepRepInstanceAdapter
extends HepRepAttributeAdapter
implements HepRepInstance {
    private HepRepInstance parent;
    private HepRepType type;
    private List instances;
    private transient String layer;
    private transient boolean hasFrame;

    public AbstractHepRepInstanceAdapter(HepRepAttribute attribute, HepRepInstance parent, HepRepType type) {
        this(null, attribute, parent, type);
    }

    public AbstractHepRepInstanceAdapter(HepRepAttribute parentAttribute, HepRepAttribute attribute, HepRepInstance parent, HepRepType type) {
        super(parentAttribute, attribute);
        this.parent = parent;
        this.type = type;
        this.instances = new ArrayList();
        this.layer = null;
        this.hasFrame = false;
    }

    @Override
    public void overlay(HepRepInstance instance) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addInstance(HepRepInstance instance) {
        this.instances.add(instance);
    }

    @Override
    public void removeInstance(HepRepInstance instance) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List getInstances() {
        return this.instances;
    }

    @Override
    public void addPoint(HepRepPoint point) {
        throw new UnsupportedOperationException();
    }

    @Override
    public HepRepType getType() {
        return this.type;
    }

    @Override
    public int getPoints(double[][] xyz) {
        return -1;
    }

    @Override
    public HepRepInstance getSuperInstance() {
        return this.parent;
    }

    @Override
    public HepRepInstance copy(HepRepTypeTree typeTree, HepRepInstance parent) throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public HepRepInstance copy(HepRepTypeTree typeTree, HepRepInstance parent, HepRepSelectFilter filter) throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public HepRepInstance copy(HepRepTypeTree typeTree, HepRepInstanceTree parent) throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public HepRepInstance copy(HepRepTypeTree typeTree, HepRepInstanceTree parent, HepRepSelectFilter filter) throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public void setUserObject(Object object) {
    }

    @Override
    public Object getUserObject() {
        return null;
    }

    @Override
    public HepRepAttValue getAttValue(String name) {
        String lowerCaseName = name.toLowerCase();
        HepRepAttValue value = this.getAttValueFromNode(lowerCaseName);
        return value != null ? value : this.type.getAttValue(lowerCaseName);
    }

    @Override
    public String getLayer() {
        this.validate();
        return this.layer;
    }

    @Override
    public boolean hasFrame() {
        this.validate();
        return this.hasFrame;
    }

    private void validate() {
        if (this.layer != null) {
            return;
        }
        this.layer = this.getAttValue("layer").getString().intern();
        this.hasFrame = this.getAttValue("hasframe").getBoolean();
    }
}

