/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.wbxml;

import hep.graphics.heprep.HepRep;
import hep.graphics.heprep.HepRepFactory;
import hep.graphics.heprep.HepRepInstance;
import hep.graphics.heprep.HepRepInstanceTree;
import hep.graphics.heprep.HepRepPoint;
import hep.graphics.heprep.HepRepTreeID;
import hep.graphics.heprep.HepRepType;
import hep.graphics.heprep.HepRepTypeTree;
import hep.graphics.heprep.HepRepVersionException;
import hep.graphics.heprep.ref.DefaultHepRepAttValue;
import hep.graphics.heprep.ref.DefaultHepRepInstance;
import hep.graphics.heprep.util.HepRepTypes;
import hep.graphics.heprep.wbxml.BHepRepParser;
import hep.graphics.heprep.xml.XMLHepRepFactory;
import java.awt.Color;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import java.util.StringTokenizer;
import org.freehep.util.VersionComparator;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class BHepRepReader
extends BHepRepParser {
    public static final String expectedVersion = "2.0";
    private HepRepFactory factory;
    private HepRep heprep;
    private int level = 0;
    private HepRepTypes types;
    private HepRepTypeTree currentTypeTree = null;
    private HepRepTreeID currentTypeTreeRef = null;
    private HepRepInstanceTree instanceTree = null;
    private HepRepPoint currentPoint = null;
    private boolean inPoint = false;
    private Stack instanceStack = new Stack();
    private HepRepInstance currentInstance = null;
    private Stack typeStack = new Stack();
    private HepRepType currentType = null;

    public BHepRepReader(HepRep heprep) {
        this.heprep = heprep;
        this.factory = new XMLHepRepFactory();
    }

    @Override
    protected void addAttribute(int attId, String prefix, String namespace, String name, Object value) {
        if (this.getTag() == 7 && (attId == 16 || attId == 17 || attId == 18 || attId == 19 || attId == 20 || attId == 21)) {
            super.addAttribute(attId, prefix, namespace, "*type", new Integer(attId));
            super.addAttribute(attId, prefix, namespace, "value", value);
            return;
        }
        super.addAttribute(attId, prefix, namespace, name, value);
    }

    @Override
    protected Object parseOpaque(int len, int tagId, int attId) throws IOException, XmlPullParserException {
        Object opaque = super.parseOpaque(len, tagId, attId);
        if (tagId == 0 && this.inPoint) {
            double[] points = (double[])opaque;
            if (len % 12 != 0) {
                throw new XmlPullParserException(this.getClass() + ": Point should have n*3*4 coordinates rather than " + len + ".");
            }
            int nPoints = len / 4;
            if (nPoints == 3) {
                this.currentPoint = this.factory.createHepRepPoint(this.currentInstance, points[0], points[1], points[2]);
            } else {
                this.currentPoint = null;
                for (int i = 0; i < nPoints; i += 3) {
                    this.factory.createHepRepPoint(this.currentInstance, points[i], points[i + 1], points[i + 2]);
                }
            }
        }
        return opaque;
    }

    public void parse(InputStream in) throws XmlPullParserException, IOException {
        this.setInput(in, null);
        int eventType = this.getEventType();
        while (eventType != 1) {
            switch (eventType) {
                case 0: {
                    this.startDocument();
                    break;
                }
                case 1: {
                    this.endDocument();
                    break;
                }
                case 2: {
                    this.startTag();
                    break;
                }
                case 3: {
                    this.endTag();
                    break;
                }
                case 4: {
                    this.text();
                    break;
                }
            }
            eventType = this.next();
        }
    }

    protected void startDocument() {
        this.types = new HepRepTypes();
        this.currentTypeTree = null;
        this.currentTypeTreeRef = null;
        this.instanceTree = null;
        this.currentPoint = null;
        this.inPoint = false;
        this.instanceStack = new Stack();
        this.currentInstance = null;
        this.typeStack = new Stack();
        this.currentType = null;
        this.level = 0;
    }

    protected void endDocument() {
    }

    protected void startTag() throws XmlPullParserException {
        ++this.level;
        switch (this.getTag()) {
            case 5: {
                String version = this.getAttributeValue("version");
                if (version != null) {
                    VersionComparator comparator = new VersionComparator();
                    if (comparator.versionNumberCompare(version, expectedVersion) >= 0) break;
                    throw new XmlPullParserException("Wrong version", (XmlPullParser)this, (Throwable)new HepRepVersionException(this.getClass() + ": Found version '" + version + "' while expected version '" + expectedVersion + "'."));
                }
                throw new XmlPullParserException("Wrong version", (XmlPullParser)this, (Throwable)new HepRepVersionException(this.getClass() + ": Missing 'version' attribute on 'heprep' tag."));
            }
            case 6: {
                if (this.currentType == null) {
                    throw new XmlPullParserException(this.getClass() + ": Cannot use 'attdef' outside 'type' tag.");
                }
                String name = this.getAttributeValue("name");
                String desc = this.getAttributeValue("desc");
                String category = this.getAttributeValue("category");
                String extra = this.getAttributeValue("extra");
                this.currentType.addAttDef(name, desc, category, extra);
                break;
            }
            case 7: {
                DefaultHepRepAttValue attValue;
                String name = this.getAttributeValue("name");
                Integer type = (Integer)this.getAttributeObject("*type");
                Integer showLabelInt = (Integer)this.getAttributeObject("showlabel");
                int showLabel = showLabelInt == null ? 0 : showLabelInt;
                switch (type) {
                    case 16: {
                        attValue = new DefaultHepRepAttValue(name, this.getAttributeValue("value"), showLabel);
                        break;
                    }
                    case 17: {
                        attValue = new DefaultHepRepAttValue(name, (Color)this.getAttributeObject("value"), showLabel);
                        break;
                    }
                    case 18: {
                        attValue = new DefaultHepRepAttValue(name, (Long)this.getAttributeObject("value"), showLabel);
                        break;
                    }
                    case 19: {
                        attValue = new DefaultHepRepAttValue(name, (Integer)this.getAttributeObject("value"), showLabel);
                        break;
                    }
                    case 20: {
                        attValue = new DefaultHepRepAttValue(name, ((String)this.getAttributeObject("value")).equalsIgnoreCase("true"), showLabel);
                        break;
                    }
                    case 21: {
                        attValue = new DefaultHepRepAttValue(name, (Double)this.getAttributeObject("value"), showLabel);
                        break;
                    }
                    default: {
                        throw new XmlPullParserException(this.getClass() + ": Unknown '*type' in 'attValue' tag: " + type + ".");
                    }
                }
                if (this.currentPoint != null) {
                    this.currentPoint.addAttValue(attValue);
                    break;
                }
                if (this.currentInstance != null) {
                    this.currentInstance.addAttValue(attValue);
                    break;
                }
                if (this.currentType != null) {
                    this.currentType.addAttValue(attValue);
                    break;
                }
                if (this.inPoint) {
                    throw new XmlPullParserException(this.getClass() + ": Coordinates of point need to come before the 'attvalue' tag.");
                }
                throw new XmlPullParserException(this.getClass() + ": Cannot use 'attvalue' outside 'type', 'instance' or 'point' tag.");
            }
            case 8: {
                String typeName = this.getAttributeValue("type");
                if (typeName == null) {
                    throw new XmlPullParserException(this.getClass() + ": Instance cannot exist without referring to a type.");
                }
                HepRepType type = this.types.getType(this.currentTypeTreeRef, typeName, this.currentInstance);
                if (type == null) {
                    throw new XmlPullParserException(this.getClass() + ": Cannot find type: '" + typeName + "' " + "in tree: '" + this.types.getID(this.currentTypeTreeRef) + "'");
                }
                this.instanceStack.push(this.currentInstance);
                if (this.currentInstance != null) {
                    this.currentInstance = this.factory.createHepRepInstance(this.currentInstance, type);
                    break;
                }
                this.currentInstance = this.factory.createHepRepInstance(this.instanceTree, type);
                break;
            }
            case 9: {
                String name = this.getAttributeValue("name");
                String version = this.getAttributeValue("version");
                String qualifier = this.getAttributeValue("qualifier");
                this.instanceTree.addInstanceTree(this.factory.createHepRepTreeID(name, version, qualifier));
                break;
            }
            case 10: {
                String name = this.getAttributeValue("name");
                String expression = this.getAttributeValue("expression");
                this.factory.createHepRepAction(name, expression);
                break;
            }
            case 11: {
                String name = this.getAttributeValue("name");
                String version = this.getAttributeValue("version");
                this.currentTypeTreeRef = this.factory.createHepRepTreeID(this.getAttributeValue("typetreename"), this.getAttributeValue("typetreeversion"));
                this.instanceTree = this.factory.createHepRepInstanceTree(name, version, this.currentTypeTreeRef);
                this.heprep.addInstanceTree(this.instanceTree);
                break;
            }
            case 12: {
                String name = this.getAttributeValue("name");
                this.typeStack.push(this.currentType);
                this.currentType = this.currentType != null ? this.factory.createHepRepType(this.currentType, name) : this.factory.createHepRepType(this.currentTypeTree, name);
                this.types.put(this.currentTypeTree, name, this.currentType);
                break;
            }
            case 13: {
                String name = this.getAttributeValue("name");
                String version = this.getAttributeValue("version");
                HepRepTreeID id = this.factory.createHepRepTreeID(name, version);
                this.currentTypeTree = this.factory.createHepRepTypeTree(id);
                this.heprep.addTypeTree(this.currentTypeTree);
                this.types.put(id, this.currentTypeTree);
                break;
            }
            case 14: {
                String order = this.getAttributeValue("order");
                StringTokenizer st = new StringTokenizer(order, ",");
                while (st.hasMoreTokens()) {
                    this.heprep.addLayer(st.nextToken().trim());
                }
                break;
            }
            case 15: {
                this.currentPoint = null;
                this.inPoint = true;
                break;
            }
            default: {
                throw new XmlPullParserException(this.getClass() + ": Unknown start tag: " + this.getTag());
            }
        }
        if (Thread.interrupted()) {
            throw new XmlPullParserException(this.getClass() + ": Interrupted", (XmlPullParser)this, (Throwable)new InterruptedException());
        }
    }

    protected void endTag() throws XmlPullParserException {
        switch (this.getTag()) {
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                if (this.currentInstance instanceof DefaultHepRepInstance) {
                    ((DefaultHepRepInstance)this.currentInstance).optimize();
                }
                this.currentInstance = (HepRepInstance)this.instanceStack.pop();
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                this.instanceTree = null;
                this.currentTypeTreeRef = null;
                break;
            }
            case 12: {
                this.currentType = (HepRepType)this.typeStack.pop();
                break;
            }
            case 13: {
                this.currentTypeTree = null;
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                this.currentPoint = null;
                this.inPoint = false;
                break;
            }
            default: {
                throw new XmlPullParserException(this.getClass() + ": Unknown end tag: " + this.getTag());
            }
        }
        if (Thread.interrupted()) {
            throw new XmlPullParserException(this.getClass() + ": Interrupted", (XmlPullParser)this, (Throwable)new InterruptedException());
        }
        --this.level;
    }

    protected void text() {
    }

    public static void main(String[] args) throws XmlPullParserException, IOException {
        System.out.println("Start");
        BHepRepReader r = new BHepRepReader(new XMLHepRepFactory().createHepRep());
        r.parse(new FileInputStream(args[0]));
    }
}

