/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.util;

import hep.graphics.heprep.HepRep;
import hep.graphics.heprep.HepRepReader;
import hep.graphics.heprep.HepRepWriter;
import hep.graphics.heprep.xml.XMLHepRepFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;

public class HepRepIO {
    private HepRepIO() {
    }

    public static HepRep readHepRep(String name, InputStream is) throws IOException {
        boolean close = false;
        if (is == null) {
            is = new FileInputStream(name);
            close = true;
        }
        Object input = HepRepIO.getHepRepInput(name, is);
        HepRep heprep = HepRepIO.readHepRep(input);
        if (close) {
            is.close();
        }
        return heprep;
    }

    public static Object getHepRepInput(String name, InputStream is) throws IOException {
        is = new BufferedInputStream(is, 1024000);
        if (name.toLowerCase().endsWith(".gz")) {
            is = new GZIPInputStream(is);
            name = name.substring(0, name.length() - 3);
        }
        if (name.toLowerCase().endsWith(".ser")) {
            return new ObjectInputStream(is);
        }
        if (name.toLowerCase().endsWith(".zip")) {
            return new ZipInputStream(is);
        }
        return is;
    }

    public static HepRep readHepRep(Object input) throws IOException {
        if (input instanceof ObjectInputStream) {
            return HepRepIO.readHepRep((ObjectInputStream)input);
        }
        if (input instanceof InputStream) {
            return HepRepIO.readHepRep((InputStream)input);
        }
        if (input instanceof String) {
            return HepRepIO.readHepRep((String)input, null);
        }
        throw new RuntimeException("HepRepUtil.readHepRep, unrecognized input class: " + input + ", accept only String, InputStream or ObjectInputStream");
    }

    public static HepRep readHepRep(ObjectInputStream objectInputStream) throws IOException {
        try {
            return (HepRep)objectInputStream.readObject();
        }
        catch (Exception e) {
            IOException exception = new IOException();
            exception.initCause(e);
            throw exception;
        }
    }

    public static HepRep readHepRep(InputStream stream) throws IOException {
        HepRepReader reader = new XMLHepRepFactory().createHepRepReader(stream);
        return reader.next();
    }

    public static void writeHepRep(HepRep heprep, String name) throws IOException {
        HepRepIO.writeHepRep(heprep, name, null);
    }

    public static OutputStream writeHepRep(HepRep heprep, String name, OutputStream os) throws IOException {
        String zipName;
        String entryName = null;
        boolean random = false;
        boolean compress = false;
        int pos = name.lastIndexOf(33);
        if (pos > 0 && (zipName = name.substring(0, pos)).toLowerCase().endsWith(".zip")) {
            random = true;
            compress = true;
            entryName = name.substring(pos + 1);
            if (entryName.equals("")) {
                entryName = "HepRep";
            } else {
                name = zipName;
            }
        }
        boolean close = false;
        if (os == null) {
            boolean append = new File(name).exists();
            os = new FileOutputStream(name, append);
            close = true;
        }
        if (random) {
            name = entryName;
        }
        os = new BufferedOutputStream(os, 1024000);
        if (name.toLowerCase().endsWith(".gz")) {
            compress = true;
            name = name.substring(0, name.length() - 3);
        }
        if (name.toLowerCase().endsWith(".xml") || name.toLowerCase().endsWith(".heprep")) {
            HepRepWriter writer = new XMLHepRepFactory().createHepRepWriter(os, random, compress);
            writer.write(heprep, name);
            if (close) {
                writer.close();
            }
        } else if (name.toLowerCase().endsWith(".ser")) {
            ObjectOutputStream dos = new ObjectOutputStream(os);
            dos.writeObject(heprep);
            if (close) {
                dos.close();
            }
        } else {
            if (name.toLowerCase().endsWith(".zip")) {
                throw new RuntimeException("HepRepUtil.writeHepRep, zip extension needs entryName specified by '!entryName'");
            }
            throw new RuntimeException("HepRepUtil.writeHepRep, unrecognized extension: " + name);
        }
        return close ? null : os;
    }
}

