/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.ref;

import hep.graphics.heprep.HepRepAttDef;
import hep.graphics.heprep.HepRepAttValue;
import hep.graphics.heprep.HepRepDefaults;
import hep.graphics.heprep.HepRepType;
import hep.graphics.heprep.HepRepTypeTree;
import hep.graphics.heprep.ref.DefaultHepRepDefinition;
import hep.graphics.heprep.util.HashMapList;
import hep.graphics.heprep.util.HepRepUtil;
import hep.graphics.heprep.util.MapList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class DefaultHepRepType
extends DefaultHepRepDefinition
implements HepRepType,
Serializable {
    private HepRepType parent;
    private String name;
    private String description = "No Description";
    private String infoURL = "No Info URL";
    private MapList types;

    protected DefaultHepRepType(String name) {
        this((HepRepType)null, name);
    }

    protected DefaultHepRepType(HepRepType parent, String name) {
        this.parent = parent;
        this.name = name.intern();
        if (parent != null) {
            parent.addType(this);
        }
    }

    protected DefaultHepRepType(HepRepTypeTree parent, String name) {
        this((HepRepType)null, name);
        parent.addType(this);
    }

    @Override
    public HepRepType getSuperType() {
        return this.parent;
    }

    @Override
    public HepRepAttDef getAttDef(String name) {
        return DefaultHepRepType.getAttDef(this, name.toLowerCase());
    }

    public static HepRepAttDef getAttDef(HepRepType type, String lowerCaseName) {
        HepRepAttDef def = null;
        while (def == null && type != null) {
            def = type.getAttDefFromNode(lowerCaseName);
            type = type.getSuperType();
        }
        if (def != null) {
            return def;
        }
        return HepRepDefaults.getAttDef(lowerCaseName);
    }

    @Override
    public HepRepAttValue getAttValue(String name) {
        return DefaultHepRepType.getAttValue(this, name.toLowerCase());
    }

    public static HepRepAttValue getAttValue(HepRepType type, String lowerCaseName) {
        HepRepAttValue value = null;
        while (value == null && type != null) {
            value = type.getAttValueFromNode(lowerCaseName);
            type = type.getSuperType();
        }
        if (value != null) {
            return value;
        }
        return HepRepDefaults.getAttValue(lowerCaseName);
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    @Override
    public HepRepType copy(HepRepType parent) throws CloneNotSupportedException {
        DefaultHepRepType copy = new DefaultHepRepType(parent, this.getName());
        copy.setDescription(this.getDescription());
        copy.setInfoURL(this.getInfoURL());
        HepRepUtil.copyAttributes(this, copy);
        for (HepRepAttDef def : this.getAttDefsFromNode()) {
            copy.addAttDef(def.copy());
        }
        for (HepRepType type : this.getTypeList()) {
            type.copy(copy);
        }
        return copy;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.getSuperType() == null ? this.getName() : this.getSuperType().getFullName() + "/" + this.getName();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getInfoURL() {
        return this.infoURL;
    }

    @Override
    public void setInfoURL(String infoURL) {
        this.infoURL = infoURL;
    }

    @Override
    public void addType(HepRepType type) {
        if (this.types == null) {
            this.types = new HashMapList();
        }
        this.types.put(type.getName(), type);
    }

    @Override
    public Set getTypes() {
        return this.types != null ? this.types.valueSet() : Collections.EMPTY_SET;
    }

    @Override
    public List getTypeList() {
        return this.types != null ? this.types.valueList() : Collections.EMPTY_LIST;
    }

    public String toString() {
        return "HepRepType: " + this.getName();
    }

    public void display(String indent) {
        System.out.println(indent + this.toString());
        System.out.println(indent + this.getDescription());
        System.out.println(indent + this.getInfoURL());
        System.out.println(indent + "#Defs: " + this.getAttDefsFromNode().size());
        System.out.println(indent + "#Atts: " + this.getAttValuesFromNode().size());
        for (DefaultHepRepType type : this.getTypeList()) {
            type.display(indent + "  ");
        }
    }
}

