/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.ref;

import hep.graphics.heprep.HepRep;
import hep.graphics.heprep.ref.AbstractHepRepReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.zip.GZIPInputStream;

public class DefaultHepRepReader
extends AbstractHepRepReader {
    protected DefaultHepRepReader(InputStream in) throws IOException {
        super(in);
        this.reset();
    }

    protected DefaultHepRepReader(String fileName) throws IOException {
        super(fileName);
        this.reset();
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        if (this.name != null) {
            this.input = this.name.toLowerCase().endsWith(".gz") ? new GZIPInputStream(new FileInputStream(this.name)) : new FileInputStream(this.name);
        } else {
            super.reset();
        }
    }

    @Override
    public HepRep readHepRep(InputStream input, boolean binary) throws IOException {
        try {
            ObjectInputStream oin = new ObjectInputStream(input);
            return (HepRep)oin.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException(this.getClass() + " Class not found: " + e.getMessage());
        }
        catch (NoClassDefFoundError e) {
            throw new IOException(this.getClass() + " ClassDef not found: " + e.getMessage());
        }
    }
}

