/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.ref;

import hep.graphics.heprep.HepRep;
import hep.graphics.heprep.HepRepAction;
import hep.graphics.heprep.HepRepInstanceTree;
import hep.graphics.heprep.HepRepSelectFilter;
import hep.graphics.heprep.HepRepTreeID;
import hep.graphics.heprep.HepRepTypeTree;
import hep.graphics.heprep.ref.DefaultHepRepInstanceTree;
import hep.graphics.heprep.ref.DefaultHepRepTreeID;
import hep.graphics.heprep.ref.DefaultHepRepTypeTree;
import hep.graphics.heprep.util.HashMapList;
import hep.graphics.heprep.util.MapList;
import hep.graphics.heprep.util.ValueSet;
import hep.graphics.heprep.xml.XMLHepRepReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class DefaultHepRep
implements HepRep,
Serializable {
    private Properties properties = new Properties();
    private List layers = null;
    private MapList instanceTrees = new HashMapList();
    private MapList typeTrees = new HashMapList();

    protected DefaultHepRep() {
        try {
            XMLHepRepReader.readDefaults();
        }
        catch (Exception e) {
            System.err.println("Warning: unable to read HepRep default attributes from XML");
        }
    }

    @Override
    public HepRep copy() throws CloneNotSupportedException {
        return this.copy(null);
    }

    @Override
    public HepRep copy(HepRepSelectFilter filter) throws CloneNotSupportedException {
        DefaultHepRep copy = new DefaultHepRep();
        Iterator i = this.getLayerOrder().iterator();
        while (i.hasNext()) {
            copy.addLayer((String)i.next());
        }
        for (HepRepTypeTree typeTree : this.getTypeTreeList()) {
            copy.addTypeTree(typeTree.copy());
        }
        for (HepRepInstanceTree instanceTree : this.getInstanceTreeList()) {
            HepRepTreeID typeTreeID = instanceTree.getTypeTree();
            HepRepTypeTree typeTree = copy.getTypeTree(typeTreeID.getName(), typeTreeID.getVersion());
            copy.addInstanceTree(instanceTree.copy(typeTree, filter));
        }
        return copy;
    }

    public String setProperty(String key, String value) {
        return (String)this.properties.setProperty(key, value);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public List getLayerOrder() {
        if (this.layers == null) {
            this.addLayer("default");
        }
        return this.layers;
    }

    @Override
    public void addLayer(String layer) {
        if (this.layers == null) {
            this.layers = new ArrayList();
        }
        this.layers.add(layer);
    }

    @Override
    public void addTypeTree(HepRepTypeTree type) {
        this.typeTrees.put(new DefaultHepRepTreeID(type.getName(), type.getVersion()), type);
    }

    @Override
    public void removeTypeTree(HepRepTypeTree typeTree) {
        this.typeTrees.remove(new DefaultHepRepTreeID(typeTree.getName(), typeTree.getVersion()));
    }

    @Override
    public HepRepTypeTree getTypeTree(String name, String version) {
        return (HepRepTypeTree)this.typeTrees.get(new DefaultHepRepTreeID(name, version));
    }

    @Override
    public Set getTypeTrees() {
        return this.typeTrees.valueSet();
    }

    @Override
    public List getTypeTreeList() {
        return this.typeTrees.valueList();
    }

    @Override
    public void addInstanceTree(HepRepInstanceTree instance) {
        this.instanceTrees.put(new DefaultHepRepTreeID(instance.getName(), instance.getVersion()), instance);
    }

    @Override
    public void overlayInstanceTree(HepRepInstanceTree instanceTree) {
        HepRepInstanceTree originalTree = this.getInstanceTreeTop(instanceTree.getName(), instanceTree.getVersion());
        if (originalTree == null) {
            throw new RuntimeException("HepRep.overlayInstanceTree cannot find instanceTree(" + instanceTree.getName() + ", " + instanceTree.getVersion() + ")");
        }
        originalTree.overlay(instanceTree);
    }

    @Override
    public void removeInstanceTree(HepRepInstanceTree instanceTree) {
        this.instanceTrees.remove(new DefaultHepRepTreeID(instanceTree.getName(), instanceTree.getVersion()));
    }

    @Override
    public HepRepInstanceTree getInstanceTreeTop(String name, String version) {
        return (HepRepInstanceTree)this.instanceTrees.get(new DefaultHepRepTreeID(name, version));
    }

    @Override
    public HepRepInstanceTree getInstances(String name, String version, String[] typeNames) {
        return this.getInstanceTreeTop(name, version);
    }

    @Override
    public HepRepInstanceTree getInstancesAfterAction(String name, String version, String[] typeNames, HepRepAction[] actions, boolean getPoints, boolean getDrawAtts, boolean getNonDrawAtts, String[] invertAtts) {
        return this.getInstanceTreeTop(name, version);
    }

    @Override
    public String checkForException() {
        return "Not Implemented";
    }

    @Override
    public Set getInstanceTrees() {
        return this.instanceTrees.valueSet();
    }

    @Override
    public List getInstanceTreeList() {
        return this.instanceTrees.valueList();
    }

    public void display() {
        System.out.println("HepRep");
        System.out.println("  Layers: " + this.getLayerOrder().size());
        for (String layer : this.getLayerOrder()) {
            System.out.println("    " + layer);
        }
        System.out.println("  TypeTrees: " + this.typeTrees.size());
        for (DefaultHepRepTreeID tree : new ValueSet(this.typeTrees)) {
            ((DefaultHepRepTypeTree)tree).display("    ");
        }
        System.out.println("  InstanceTrees: " + this.instanceTrees.size());
        for (DefaultHepRepTreeID tree : new ValueSet(this.instanceTrees)) {
            ((DefaultHepRepInstanceTree)tree).display("    ");
        }
    }
}

