/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.ref;

import hep.graphics.heprep.HepRep;
import hep.graphics.heprep.HepRepInstanceTree;
import hep.graphics.heprep.HepRepReader;
import hep.graphics.heprep.HepRepTreeID;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractSequentialList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.freehep.util.io.NoCloseInputStream;

public abstract class AbstractHepRepReader
implements HepRepReader {
    protected InputStream input;
    protected String name;
    private ZipEntry entry;
    private ZipInputStream zip;
    protected ZipFile zipFile;
    private Enumeration zipEntries;
    private int position;
    private Properties properties = new Properties();
    private Set skip = new HashSet();

    private AbstractHepRepReader() {
    }

    protected AbstractHepRepReader(InputStream in) throws IOException {
        this();
        this.input = in;
    }

    protected AbstractHepRepReader(String fileName) throws IOException {
        this();
        this.name = fileName;
    }

    @Override
    public String getProperty(String key, String defaultValue) throws IOException {
        return this.properties.getProperty(key, defaultValue);
    }

    @Override
    public void close() throws IOException {
        if (this.zip != null) {
            this.zip.close();
        }
        if (this.zipFile != null) {
            this.zipFile.close();
        }
    }

    @Override
    public boolean hasSequentialAccess() throws IOException {
        return true;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        if (this.input instanceof ZipInputStream) {
            this.zip = (ZipInputStream)this.input;
            this.zip.reset();
        } else if (this.name != null && this.name.toLowerCase().endsWith(".zip")) {
            this.zipFile = new ZipFile(this.name);
            this.zipEntries = this.zipFile.entries();
            this.position = 0;
            ZipEntry propEntry = this.zipFile.getEntry("heprep.properties");
            if (propEntry != null) {
                this.skip.add("heprep.properties");
                InputStream propStream = this.zipFile.getInputStream(propEntry);
                this.properties.load(propStream);
                propStream.close();
                String ignoreList = this.properties.getProperty("RecordLoop.ignore", null);
                if (ignoreList != null) {
                    this.skip.addAll(Arrays.asList(ignoreList.split(":")));
                }
            }
        }
    }

    @Override
    public int size() {
        if (this.zipFile != null) {
            return this.zipFile.size() - this.skip.size();
        }
        return -1;
    }

    @Override
    public int skip(int n) throws UnsupportedOperationException {
        int i;
        try {
            for (i = n; i > 0 && this.hasNext(); --i) {
                this.next();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n - i;
    }

    @Override
    public boolean hasNext() throws IOException, UnsupportedOperationException {
        if (this.zipFile != null) {
            return this.size() - this.position > 0;
        }
        return true;
    }

    @Override
    public HepRep next() throws IOException, UnsupportedOperationException, NoSuchElementException {
        if (!this.hasNext()) {
            throw new UnsupportedOperationException(this.getClass() + " no more elements");
        }
        if (this.zip != null) {
            this.entry = this.zip.getNextEntry();
            while (this.skip.contains(this.entry.getName())) {
                this.entry = this.zip.getNextEntry();
            }
            BufferedInputStream stream = new BufferedInputStream(new NoCloseInputStream(this.zip));
            return this.readHepRep(stream, this.entry.getName().endsWith(".bheprep"));
        }
        if (this.zipFile != null) {
            this.entry = (ZipEntry)this.zipEntries.nextElement();
            while (this.skip.contains(this.entry.getName())) {
                this.entry = (ZipEntry)this.zipEntries.nextElement();
            }
            ++this.position;
            InputStream stream = this.zipFile.getInputStream(this.entry);
            if (this.entry.getName().toLowerCase().endsWith(".gz")) {
                stream = new GZIPInputStream(stream);
            }
            stream = new BufferedInputStream(stream);
            HepRep heprep = this.readHepRep(stream, this.entry.getName().endsWith(".bheprep"));
            for (HepRepInstanceTree tree : heprep.getInstanceTreeList()) {
                for (HepRepTreeID id : tree.getInstanceTreeList()) {
                    String[] name = id.getName().split("#", 2);
                    ZipEntry zipEntry = this.zipFile.getEntry(name[0]);
                    if (zipEntry == null) continue;
                    BufferedInputStream zipStream = new BufferedInputStream(this.zipFile.getInputStream(zipEntry));
                    HepRep h = this.readHepRep(zipStream, name[0].endsWith(".bheprep"));
                    Iterator k = h.getInstanceTreeList().iterator();
                    while (k.hasNext()) {
                        k.next();
                    }
                }
            }
            return heprep;
        }
        return null;
    }

    @Override
    public boolean hasRandomAccess() {
        return this.zipFile != null;
    }

    @Override
    public HepRep read(String name) throws IOException, UnsupportedOperationException, NoSuchElementException {
        if (!this.hasRandomAccess()) {
            throw new UnsupportedOperationException(this.getClass() + " does not support random access");
        }
        this.entry = this.zipFile.getEntry(name);
        if (this.entry == null) {
            throw new NoSuchElementException(this.getClass() + " cannot access entry '" + name + "'");
        }
        BufferedInputStream stream = new BufferedInputStream(this.zipFile.getInputStream(this.entry));
        return this.readHepRep(stream, name.endsWith(".bheprep"));
    }

    @Override
    public String entryName() {
        return this.entry != null ? this.entry.getName() : null;
    }

    @Override
    public List entryNames() {
        if (this.zipFile == null) {
            return null;
        }
        AbstractSequentialList list = new AbstractSequentialList(){

            @Override
            public int size() {
                return AbstractHepRepReader.this.size();
            }

            @Override
            public ListIterator listIterator(int index) {
                final int startIndex = index;
                return new ListIterator(){
                    private int position;
                    private Enumeration entries;
                    private ZipEntry entry;
                    {
                        this.entries = AbstractHepRepReader.this.zipFile.entries();
                        this.position = startIndex;
                        for (int i = 0; i <= this.position; ++i) {
                            ZipEntry zipEntry = this.entry = this.entries.hasMoreElements() ? (ZipEntry)this.entries.nextElement() : null;
                            while (this.entry != null && AbstractHepRepReader.this.skip.contains(this.entry.getName())) {
                                this.entry = this.entries.hasMoreElements() ? (ZipEntry)this.entries.nextElement() : null;
                            }
                            if (this.entry == null) break;
                        }
                        if (this.entry == null) {
                            this.position = this.size();
                        }
                    }

                    public void add(Object o) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.entry != null;
                    }

                    @Override
                    public boolean hasPrevious() {
                        return false;
                    }

                    @Override
                    public Object next() {
                        if (this.entry == null) {
                            throw new NoSuchElementException();
                        }
                        return this.entry.getName();
                    }

                    @Override
                    public int nextIndex() {
                        return this.position;
                    }

                    public Object previous() {
                        throw new NoSuchElementException();
                    }

                    @Override
                    public int previousIndex() {
                        return this.position - 1;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    public void set(Object o) {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        return list;
    }

    protected abstract HepRep readHepRep(InputStream var1, boolean var2) throws IOException;

    protected HepRep readHepRep(InputStream input) throws IOException {
        return this.readHepRep(input, false);
    }
}

