/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.corbavalue;

import hep.graphics.heprep.HepRepAttValue;
import hep.graphics.heprep.HepRepInstance;
import hep.graphics.heprep.corbavalue.HepRepAttributeAdapter;
import hep.graphics.heprep.corbavalue.idl.HepRepAttribute;
import hep.graphics.heprep.corbavalue.idl.HepRepPoint;
import hep.graphics.heprep.ref.DefaultHepRepFactory;
import hep.graphics.heprep.util.HepRepMath;
import hep.graphics.heprep.util.HepRepUtil;

public class HepRepPointAdapter
extends HepRepAttributeAdapter
implements hep.graphics.heprep.HepRepPoint {
    private HepRepPoint hepRepPoint;
    private HepRepInstance instance;

    public HepRepPointAdapter(HepRepPoint hepRepPoint, HepRepInstance instance) {
        super((HepRepAttribute)hepRepPoint);
        this.hepRepPoint = hepRepPoint;
        this.instance = instance;
    }

    @Override
    public hep.graphics.heprep.HepRepPoint copy(HepRepInstance parent) throws CloneNotSupportedException {
        hep.graphics.heprep.HepRepPoint copy = new DefaultHepRepFactory().createHepRepPoint(parent, this.getX(), this.getY(), this.getZ());
        HepRepUtil.copyAttributes(this, copy);
        return copy;
    }

    @Override
    public HepRepInstance getInstance() {
        return this.instance;
    }

    @Override
    public HepRepAttValue getAttValue(String lowerCaseName) {
        HepRepAttValue attValue = this.getAttValueFromNode(lowerCaseName);
        return attValue != null ? attValue : this.getInstance().getAttValue(lowerCaseName);
    }

    @Override
    public double getX() {
        return this.hepRepPoint.x;
    }

    @Override
    public double getY() {
        return this.hepRepPoint.y;
    }

    @Override
    public double getZ() {
        return this.hepRepPoint.z;
    }

    @Override
    public double[] getXYZ(double[] xyz) {
        if (xyz == null) {
            xyz = new double[]{this.hepRepPoint.x, this.hepRepPoint.y, this.hepRepPoint.z};
        }
        return xyz;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        return o instanceof hep.graphics.heprep.HepRepPoint;
    }

    @Override
    public int hashCode() {
        long r = Double.doubleToLongBits(this.getX()) + Double.doubleToLongBits(this.getY()) + Double.doubleToLongBits(this.getZ());
        return (int)r;
    }

    @Override
    public double getRho() {
        return HepRepMath.getRho(this.hepRepPoint.x, this.hepRepPoint.y);
    }

    @Override
    public double getPhi() {
        return HepRepMath.getPhi(this.hepRepPoint.x, this.hepRepPoint.y);
    }

    @Override
    public double getTheta() {
        return HepRepMath.getTheta(this.hepRepPoint.x, this.hepRepPoint.y, this.hepRepPoint.z);
    }

    @Override
    public double getR() {
        return HepRepMath.getR(this.hepRepPoint.x, this.hepRepPoint.y, this.hepRepPoint.z);
    }

    @Override
    public double getEta() {
        return HepRepMath.getEta(this.hepRepPoint.x, this.hepRepPoint.y, this.hepRepPoint.z);
    }

    @Override
    public double getX(double xVertex, double yVertex, double zVertex) {
        return HepRepMath.getX(this.hepRepPoint.x, xVertex);
    }

    @Override
    public double getY(double xVertex, double yVertex, double zVertex) {
        return HepRepMath.getY(this.hepRepPoint.y, yVertex);
    }

    @Override
    public double getZ(double xVertex, double yVertex, double zVertex) {
        return HepRepMath.getZ(this.hepRepPoint.z, zVertex);
    }

    @Override
    public double getRho(double xVertex, double yVertex, double zVertex) {
        return HepRepMath.getRho(this.hepRepPoint.x, this.hepRepPoint.y, xVertex, yVertex);
    }

    @Override
    public double getPhi(double xVertex, double yVertex, double zVertex) {
        return HepRepMath.getPhi(this.hepRepPoint.x, this.hepRepPoint.y, xVertex, yVertex);
    }

    @Override
    public double getTheta(double xVertex, double yVertex, double zVertex) {
        return HepRepMath.getTheta(this.hepRepPoint.x, this.hepRepPoint.y, this.hepRepPoint.z, xVertex, yVertex, zVertex);
    }

    @Override
    public double getR(double xVertex, double yVertex, double zVertex) {
        return HepRepMath.getR(this.hepRepPoint.x, this.hepRepPoint.y, this.hepRepPoint.z, xVertex, yVertex, zVertex);
    }

    @Override
    public double getEta(double xVertex, double yVertex, double zVertex) {
        return HepRepMath.getEta(this.hepRepPoint.x, this.hepRepPoint.y, this.hepRepPoint.z, xVertex, yVertex, zVertex);
    }
}

