/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.corbavalue;

import hep.graphics.heprep.HepRepAttValue;
import hep.graphics.heprep.HepRepAttribute;
import hep.graphics.heprep.corbavalue.HepRepAttValueAdapter;
import hep.graphics.heprep.ref.DefaultHepRepAttValue;
import hep.graphics.heprep.util.ValueSet;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public abstract class HepRepAttributeAdapter
implements HepRepAttribute {
    private hep.graphics.heprep.corbavalue.idl.HepRepAttribute hepRepAttribute;
    private transient Map atts;

    private void fillAtts() {
        if (this.atts == null) {
            this.atts = new Hashtable();
            int n = this.hepRepAttribute.attValues.length;
            for (int i = 0; i < n; ++i) {
                HepRepAttValueAdapter value = new HepRepAttValueAdapter(this.hepRepAttribute.attValues[i]);
                this.atts.put(value.getLowerCaseName(), value);
            }
        }
    }

    public HepRepAttributeAdapter(hep.graphics.heprep.corbavalue.idl.HepRepAttribute hepRepAttribute) {
        this.hepRepAttribute = hepRepAttribute;
    }

    @Override
    public Set getAttValuesFromNode() {
        this.fillAtts();
        return new ValueSet(this.atts);
    }

    @Override
    public HepRepAttValue getAttValueFromNode(String lowerCaseName) {
        lowerCaseName = lowerCaseName.intern();
        this.fillAtts();
        return (HepRepAttValue)this.atts.get(lowerCaseName);
    }

    @Override
    public void addAttValue(String key, String value) {
        this.addAttValue(key, value, 0);
    }

    @Override
    public void addAttValue(String key, int value) {
        this.addAttValue(key, value, 0);
    }

    @Override
    public void addAttValue(String key, long value) {
        this.addAttValue(key, value, 0);
    }

    @Override
    public void addAttValue(String key, double value) {
        this.addAttValue(key, value, 0);
    }

    @Override
    public void addAttValue(String key, boolean value) {
        this.addAttValue(key, value, 0);
    }

    @Override
    public void addAttValue(String key, Color value) {
        this.addAttValue(key, value, 0);
    }

    @Override
    public void addAttValue(String key, String value, int showLabel) {
        this.addAttValue(new DefaultHepRepAttValue(key, value, showLabel));
    }

    @Override
    public void addAttValue(String key, int value, int showLabel) {
        this.addAttValue(new DefaultHepRepAttValue(key, value, showLabel));
    }

    @Override
    public void addAttValue(String key, long value, int showLabel) {
        this.addAttValue(new DefaultHepRepAttValue(key, value, showLabel));
    }

    @Override
    public void addAttValue(String key, double value, int showLabel) {
        this.addAttValue(new DefaultHepRepAttValue(key, value, showLabel));
    }

    @Override
    public void addAttValue(String key, boolean value, int showLabel) {
        this.addAttValue(new DefaultHepRepAttValue(key, value, showLabel));
    }

    @Override
    public void addAttValue(String key, Color value, int showLabel) {
        this.addAttValue(new DefaultHepRepAttValue(key, value, showLabel));
    }

    @Override
    public void addAttValue(HepRepAttValue attValue) {
        this.fillAtts();
        this.atts.put(attValue.getLowerCaseName(), attValue);
    }

    @Override
    public HepRepAttValue removeAttValue(String key) {
        if (this.atts == null) {
            return null;
        }
        return (HepRepAttValue)this.atts.remove(key.toLowerCase());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HepRepAttribute) {
            HepRepAttribute att = (HepRepAttribute)o;
            HepRepAttValue layer = this.getAttValueFromNode("layer");
            HepRepAttValue attLayer = att.getAttValueFromNode("layer");
            if (layer != null ? !layer.equals(attLayer) : attLayer != null) {
                return false;
            }
            return att.getAttValuesFromNode().equals(this.getAttValuesFromNode());
        }
        return false;
    }

    public int hashCode() {
        long code = 0L;
        HepRepAttValue layer = this.getAttValueFromNode("layer");
        if (layer != null) {
            code += (long)layer.hashCode();
        }
        return (int)(code += (long)this.getAttValuesFromNode().hashCode());
    }
}

