/*
 * Decompiled with CFR 0.152.
 */
package hep.graphics.heprep.corba;

import hep.graphics.heprep.HepRep;
import hep.graphics.heprep.HepRepFactory;
import hep.graphics.heprep.HepRepInstanceTree;
import hep.graphics.heprep.HepRepSelectFilter;
import hep.graphics.heprep.HepRepTreeID;
import hep.graphics.heprep.HepRepTypeTree;
import hep.graphics.heprep.corba.HepRepInstanceTreeAdapter;
import hep.graphics.heprep.corba.HepRepTypeTreeAdapter;
import hep.graphics.heprep.corba.idl.HepRepAction;
import hep.graphics.heprep.ref.DefaultHepRepFactory;
import hep.graphics.heprep.util.HashMapList;
import hep.graphics.heprep.util.MapList;
import hep.graphics.heprep.xml.XMLHepRepReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class HepRepAdapter
implements HepRep {
    private HepRepFactory factory;
    private hep.graphics.heprep.corba.idl.HepRep hepRep;
    private MapList instanceTrees = new HashMapList();
    private MapList typeTrees = new HashMapList();

    public HepRepAdapter(hep.graphics.heprep.corba.idl.HepRep hepRep) {
        this.hepRep = hepRep;
        this.factory = new DefaultHepRepFactory();
        try {
            XMLHepRepReader.readDefaults();
        }
        catch (Exception e) {
            System.err.println("Warning: unable to read HepRep default attributes from XML");
        }
    }

    @Override
    public HepRep copy() throws CloneNotSupportedException {
        return this.copy(null);
    }

    @Override
    public HepRep copy(HepRepSelectFilter filter) throws CloneNotSupportedException {
        HepRep copy = this.factory.createHepRep();
        Iterator i = this.getLayerOrder().iterator();
        while (i.hasNext()) {
            copy.addLayer((String)i.next());
        }
        for (HepRepTypeTree typeTree : this.getTypeTreeList()) {
            copy.addTypeTree(typeTree.copy());
        }
        for (HepRepInstanceTree instanceTree : this.getInstanceTreeList()) {
            HepRepTreeID typeTreeID = instanceTree.getTypeTree();
            HepRepTypeTree typeTree = copy.getTypeTree(typeTreeID.getName(), typeTreeID.getVersion());
            copy.addInstanceTree(instanceTree.copy(typeTree, filter));
        }
        return copy;
    }

    @Override
    public void addLayer(String layer) {
        throw new RuntimeException("HepRepAdapter.addLayer is not implemented.");
    }

    @Override
    public List getLayerOrder() {
        return Arrays.asList(this.hepRep.getLayerOrder());
    }

    @Override
    public void addTypeTree(HepRepTypeTree typeTree) {
        this.typeTrees.put(this.factory.createHepRepTreeID(typeTree.getName(), typeTree.getVersion()), typeTree);
    }

    @Override
    public void removeTypeTree(HepRepTypeTree typeTree) {
        this.typeTrees.remove(this.factory.createHepRepTreeID(typeTree.getName(), typeTree.getVersion()));
    }

    @Override
    public HepRepTypeTree getTypeTree(String name, String version) {
        HepRepTypeTree typeTree = (HepRepTypeTree)this.typeTrees.get(this.factory.createHepRepTreeID(name, version));
        if (typeTree == null) {
            typeTree = new HepRepTypeTreeAdapter(this.hepRep.getTypeTree(name, version));
            this.typeTrees.put(this.factory.createHepRepTreeID(typeTree.getName(), typeTree.getVersion()), typeTree);
        }
        return typeTree;
    }

    @Override
    public Set getTypeTrees() {
        return this.typeTrees.valueSet();
    }

    @Override
    public List getTypeTreeList() {
        return this.typeTrees.valueList();
    }

    @Override
    public void addInstanceTree(HepRepInstanceTree instanceTree) {
        this.instanceTrees.put(this.factory.createHepRepTreeID(instanceTree.getName(), instanceTree.getVersion()), instanceTree);
    }

    @Override
    public void overlayInstanceTree(HepRepInstanceTree instanceTree) {
        throw new RuntimeException("HepRepAdapter.overlayInstanceTree is not implemented.");
    }

    @Override
    public void removeInstanceTree(HepRepInstanceTree instanceTree) {
        this.instanceTrees.remove(this.factory.createHepRepTreeID(instanceTree.getName(), instanceTree.getVersion()));
    }

    @Override
    public HepRepInstanceTree getInstanceTreeTop(String name, String version) {
        HepRepInstanceTree instanceTree = (HepRepInstanceTree)this.instanceTrees.get(this.factory.createHepRepTreeID(name, version));
        if (instanceTree == null) {
            instanceTree = new HepRepInstanceTreeAdapter(this, this.hepRep.getInstanceTreeTop(name, version));
            this.instanceTrees.put(this.factory.createHepRepTreeID(instanceTree.getName(), instanceTree.getVersion()), instanceTree);
        }
        return instanceTree;
    }

    @Override
    public HepRepInstanceTree getInstances(String name, String version, String[] typeNames) {
        return new HepRepInstanceTreeAdapter(this, this.hepRep.getInstances(name, version, typeNames));
    }

    @Override
    public HepRepInstanceTree getInstancesAfterAction(String name, String version, String[] typeNames, hep.graphics.heprep.HepRepAction[] actions, boolean getPoints, boolean getDrawAtts, boolean getNonDrawAtts, String[] invertAtts) {
        HepRepAction[] hepRepActions = new HepRepAction[actions.length];
        for (int i = 0; i < hepRepActions.length; ++i) {
            hepRepActions[i] = new HepRepAction(actions[i].getName(), actions[i].getExpression());
        }
        return new HepRepInstanceTreeAdapter(this, this.hepRep.getInstancesAfterAction(name, version, typeNames, hepRepActions, getPoints, getDrawAtts, getNonDrawAtts, invertAtts));
    }

    @Override
    public String checkForException() {
        return this.hepRep.checkForException();
    }

    @Override
    public Set getInstanceTrees() {
        return this.instanceTrees.valueSet();
    }

    @Override
    public List getInstanceTreeList() {
        return this.instanceTrees.valueList();
    }

    public boolean equals(Object o) {
        if (o instanceof HepRep) {
            HepRep ref = (HepRep)o;
            if (!ref.getLayerOrder().equals(this.getLayerOrder())) {
                return false;
            }
            if (!ref.getTypeTreeList().equals(this.getTypeTreeList())) {
                return false;
            }
            return ref.getInstanceTreeList().equals(this.getInstanceTreeList());
        }
        return false;
    }

    public int hashCode() {
        long code = this.getLayerOrder().hashCode();
        code += (long)this.getTypeTreeList().hashCode();
        return (int)(code += (long)this.getInstanceTreeList().hashCode());
    }
}

