/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.xml;

import hep.aida.IAnnotation;
import hep.aida.IAxis;
import hep.aida.IDataPoint;
import hep.aida.IFunction;
import hep.aida.IManagedObject;
import hep.aida.IMeasurement;
import hep.aida.IModelFunction;
import hep.aida.dev.IAddable;
import hep.aida.dev.IDevManagedObject;
import hep.aida.ref.Annotation;
import hep.aida.ref.ContainerManagedObject;
import hep.aida.ref.fitter.FitParameterSettings;
import hep.aida.ref.fitter.FitResult;
import hep.aida.ref.function.FunctionCatalog;
import hep.aida.ref.histogram.Cloud1D;
import hep.aida.ref.histogram.Cloud2D;
import hep.aida.ref.histogram.Cloud3D;
import hep.aida.ref.histogram.DataPointSet;
import hep.aida.ref.histogram.FixedAxis;
import hep.aida.ref.histogram.Histogram1D;
import hep.aida.ref.histogram.Histogram2D;
import hep.aida.ref.histogram.Histogram3D;
import hep.aida.ref.histogram.Profile1D;
import hep.aida.ref.histogram.Profile2D;
import hep.aida.ref.histogram.VariableAxis;
import hep.aida.ref.tree.Folder;
import hep.aida.ref.tuple.Tuple;
import hep.aida.ref.xml.AidaBinaryHandler;
import hep.aida.ref.xml.AidaHandler;
import hep.aida.ref.xml.binary.AidaWBXMLConverter;
import hep.aida.ref.xml.binary.AidaWBXMLLookup;
import java.util.ArrayList;
import java.util.Stack;
import java.util.StringTokenizer;
import org.freehep.wbxml.Attributes;
import org.xml.sax.SAXException;

public class AidaHandlerImpl
extends AidaWBXMLLookup
implements AidaHandler,
AidaBinaryHandler {
    public static final boolean DEBUG = false;
    private Cloud1D cloud1d;
    private Cloud2D cloud2d;
    private Cloud3D cloud3d;
    private DataPointSet dataPointSet;
    private IAnnotation annotation;
    private IAnnotation saveAnnotation;
    private IDataPoint dataPoint;
    private Stack stack = new Stack();
    private String aidaVersion;
    private String name;
    private String options;
    private String path;
    private String saveName;
    private String saveTitle;
    private String title;
    private IAddable tree;
    private Tuple tuple;
    private IAxis[] axes = new IAxis[3];
    private double[] binBorders;
    private int[] entries1d;
    private int[][] entries2d;
    private int[][][] entries3d;
    private double[] errors1d;
    private double[][] errors2d;
    private double[][][] errors3d;
    private double[] heights1d;
    private double[][] heights2d;
    private double[][][] heights3d;
    private double[] mean = new double[3];
    private double[] means1d;
    private double[][] meansx2d;
    private double[][][] meansx3d;
    private double[][] meansy2d;
    private double[][][] meansy3d;
    private double[][][] meansz3d;
    private double[] rms = new double[3];
    private double[] rmss1d;
    private double[][] rmssx2d;
    private double[][][] rmssx3d;
    private double[][] rmssy2d;
    private double[][][] rmssy3d;
    private double[][][] rmssz3d;
    private boolean aida22;
    private boolean beforeAida33;
    private boolean hasBinMeanAndRms;
    private double binMax;
    private double binMin;
    private int column;
    private int nAxis;
    private int nBin;
    private int nBins;
    private int nextCoord;
    private IFunction function;
    private String argName;
    private boolean isNormalized;
    private String tupleString = "";
    private int innerFolders = 0;
    private FitResult fitResult;
    private ArrayList constrains;
    private String fitName;
    private String fitTitle;
    private String fitPath;
    private String fitOptions;
    private boolean markAsFilled = true;

    public AidaHandlerImpl(IAddable tree) {
        this(tree, true);
    }

    public AidaHandlerImpl(IAddable tree, boolean markAsFilled) {
        this.tree = tree;
        this.markAsFilled = markAsFilled;
    }

    @Override
    public void start_fitResult(org.xml.sax.Attributes atts) throws SAXException {
        this.start_fitResult(new AttributesAdapter(atts));
    }

    public void start_fitResult(Attributes meta) throws SAXException {
        int dim = meta.getIntValue(73);
        this.fitResult = new FitResult(dim);
        this.fitName = meta.getStringValue(14, "");
        this.fitTitle = meta.getStringValue(this.aida22 ? 72 : 15, "");
        this.fitPath = meta.getStringValue(16, "");
        this.fitOptions = meta.getStringValue(17, "");
        this.fitResult.setNdf(meta.getIntValue(79));
        this.fitResult.setEngineName(meta.getStringValue(74));
        this.fitResult.setFitMethodName(meta.getStringValue(75));
        this.fitResult.setIsValid(meta.getBooleanValue(76));
        this.fitResult.setQuality(meta.getDoubleValue(77));
        this.fitResult.setFitStatus(meta.getIntValue(78));
        this.fitResult.setDataDescription(meta.getStringValue(80));
    }

    @Override
    public void end_fitResult() throws SAXException {
        if (this.function != null) {
            this.fitResult.setFittedFunction(this.function);
            this.function = null;
        }
        if (this.constrains != null && this.constrains.size() > 0) {
            String[] constr = new String[this.constrains.size()];
            constr = this.constrains.toArray(constr);
            this.constrains.clear();
            this.fitResult.setConstraints(constr);
        }
        this.constrains = null;
        ContainerManagedObject cmo = new ContainerManagedObject(this.name);
        cmo.setObject(this.fitResult);
        this.add(this.path, (IManagedObject)cmo);
        this.fitResult = null;
        this.fitName = null;
        this.fitTitle = null;
        this.fitPath = null;
        this.fitOptions = null;
    }

    @Override
    public void start_covarianceMatrix(org.xml.sax.Attributes atts) throws SAXException {
        this.start_covarianceMatrix(new AttributesAdapter(atts));
    }

    public void start_covarianceMatrix(Attributes meta) throws SAXException {
    }

    @Override
    public void end_covarianceMatrix() throws SAXException {
    }

    @Override
    public void handle_fittedParameter(org.xml.sax.Attributes atts) throws SAXException {
        this.handle_fittedParameter(new AttributesAdapter(atts));
    }

    public void handle_fittedParameter(Attributes meta) throws SAXException {
        String fpName = meta.getStringValue(81);
        FitParameterSettings fps = new FitParameterSettings(fpName);
        fps.setFixed(meta.getBooleanValue(85, false));
        double stepSize = meta.getDoubleValue(86, Double.NaN);
        if (!Double.isNaN(stepSize)) {
            fps.setStepSize(stepSize);
        }
        double bound = meta.getDoubleValue(87, Double.NEGATIVE_INFINITY);
        fps.setLowerBound(bound);
        bound = meta.getDoubleValue(88, Double.POSITIVE_INFINITY);
        fps.setUpperBound(bound);
        this.fitResult.setFitParameterSettings(fpName, fps);
    }

    @Override
    public void handle_fitConstraint(org.xml.sax.Attributes atts) throws SAXException {
        this.handle_fitConstraint(new AttributesAdapter(atts));
    }

    public void handle_fitConstraint(Attributes meta) throws SAXException {
        String fcValue;
        if (this.constrains == null) {
            this.constrains = new ArrayList();
        }
        if ((fcValue = meta.getStringValue(92)) != null && !fcValue.trim().equals("")) {
            this.constrains.add(fcValue);
        }
    }

    @Override
    public void handle_matrixElement(org.xml.sax.Attributes atts) throws SAXException {
        this.handle_matrixElement(new AttributesAdapter(atts));
    }

    public void handle_matrixElement(Attributes meta) throws SAXException {
        int i = meta.getIntValue(89);
        int j = meta.getIntValue(90);
        this.fitResult.setCovMatrixElement(i, j, meta.getDoubleValue(91));
    }

    @Override
    public void end_aida() throws SAXException {
    }

    @Override
    public void end_annotation() throws SAXException {
    }

    @Override
    public void end_argument() throws SAXException {
    }

    @Override
    public void end_arguments() throws SAXException {
        if (this.function instanceof IModelFunction) {
            IModelFunction model = (IModelFunction)this.function;
            model.normalize(this.isNormalized);
        }
    }

    @Override
    public void end_axis() throws SAXException {
        this.axes[this.nAxis] = this.binBorders != null ? new VariableAxis(this.binBorders) : new FixedAxis(this.nBins, this.binMin, this.binMax);
    }

    @Override
    public void end_cloud1d() throws SAXException {
        if (this.annotation != null) {
            this.cloud1d.setAnnotation(this.annotation);
            this.annotation = null;
        }
        this.cloud1d.setTitle(this.title == null ? this.name : this.title);
        this.add(this.path, (IManagedObject)this.cloud1d);
        this.cloud1d = null;
    }

    @Override
    public void end_cloud2d() throws SAXException {
        if (this.annotation != null) {
            this.cloud2d.setAnnotation(this.annotation);
            this.annotation = null;
        }
        this.cloud2d.setTitle(this.title == null ? this.name : this.title);
        this.add(this.path, (IManagedObject)this.cloud2d);
        this.cloud2d = null;
    }

    @Override
    public void end_cloud3d() throws SAXException {
        if (this.annotation != null) {
            this.cloud3d.setAnnotation(this.annotation);
            this.annotation = null;
        }
        this.cloud3d.setTitle(this.title == null ? this.name : this.title);
        this.add(this.path, (IManagedObject)this.cloud3d);
        this.cloud3d = null;
    }

    @Override
    public void end_columns() throws SAXException {
        if (this.innerFolders != 0) {
            this.tupleString = this.tupleString + "}";
            --this.innerFolders;
        }
    }

    @Override
    public void end_data1d() throws SAXException {
    }

    @Override
    public void end_data2d() throws SAXException {
    }

    @Override
    public void end_data3d() throws SAXException {
    }

    @Override
    public void end_dataPoint() throws SAXException {
    }

    @Override
    public void end_dataPointSet() throws SAXException {
        if (this.annotation != null) {
            this.dataPointSet.setAnnotation(this.annotation);
            this.annotation = null;
        }
        this.dataPointSet.setTitle(this.title == null ? this.name : this.title);
        this.add(this.path, (IManagedObject)this.dataPointSet);
        this.dataPointSet = null;
    }

    @Override
    public void end_entries1d() throws SAXException {
    }

    @Override
    public void end_entries2d() throws SAXException {
    }

    @Override
    public void end_entries3d() throws SAXException {
    }

    @Override
    public void end_entryITuple() throws SAXException {
        Object[] elements = (Object[])this.stack.pop();
        this.tuple = (Tuple)elements[0];
        this.column = (Integer)elements[1];
        ++this.column;
    }

    @Override
    public void end_function() throws SAXException {
        ((IDevManagedObject)this.function).setName(this.name);
        if (this.fitResult == null) {
            this.add(this.path, (IManagedObject)this.function);
        }
    }

    @Override
    public void end_histogram1d() throws SAXException {
        Histogram1D hist = new Histogram1D();
        hist.setName(this.name);
        hist.initHistogram1D(this.axes[0], this.options);
        hist.setContents(this.heights1d, this.errors1d, this.entries1d, this.means1d, this.rmss1d);
        hist.setMeanAndRms(this.mean[0], this.rms[0]);
        if (this.annotation != null) {
            hist.setAnnotation(this.annotation);
            this.annotation = null;
        }
        hist.setTitle(this.title == null ? this.name : this.title);
        if (this.cloud1d != null) {
            this.cloud1d.setHistogram(hist);
            this.annotation = this.saveAnnotation;
            this.title = this.saveTitle;
            this.name = this.saveName;
        } else {
            this.add(this.path, (IManagedObject)hist);
        }
    }

    @Override
    public void end_histogram2d() throws SAXException {
        Histogram2D hist = new Histogram2D();
        hist.setName(this.name);
        hist.initHistogram2D(this.axes[0], this.axes[1], this.options);
        hist.setContents(this.heights2d, this.errors2d, this.entries2d, this.meansx2d, this.rmssx2d, this.meansy2d, this.rmssy2d);
        if (!this.hasBinMeanAndRms) {
            hist.setMeanX(this.mean[0]);
            hist.setRmsX(this.rms[0]);
            hist.setMeanY(this.mean[1]);
            hist.setRmsY(this.rms[1]);
        }
        if (this.annotation != null) {
            hist.setAnnotation(this.annotation);
            this.annotation = null;
        }
        hist.setTitle(this.title == null ? this.name : this.title);
        if (this.cloud2d != null) {
            this.cloud2d.setHistogram(hist);
            this.annotation = this.saveAnnotation;
            this.title = this.saveTitle;
            this.name = this.saveName;
        } else {
            this.add(this.path, (IManagedObject)hist);
        }
    }

    @Override
    public void end_histogram3d() throws SAXException {
        Histogram3D hist = new Histogram3D();
        hist.setName(this.name);
        hist.initHistogram3D(this.axes[0], this.axes[1], this.axes[2], this.options);
        hist.setContents(this.heights3d, this.errors3d, this.entries3d, this.meansx3d, this.rmssx3d, this.meansy3d, this.rmssy3d, this.meansz3d, this.rmssz3d);
        if (!this.hasBinMeanAndRms) {
            hist.setMeanX(this.mean[0]);
            hist.setRmsX(this.rms[0]);
            hist.setMeanY(this.mean[1]);
            hist.setRmsY(this.rms[1]);
            hist.setMeanZ(this.mean[2]);
            hist.setRmsZ(this.rms[2]);
        }
        if (this.annotation != null) {
            hist.setAnnotation(this.annotation);
            this.annotation = null;
        }
        hist.setTitle(this.title == null ? this.name : this.title);
        if (this.cloud3d != null) {
            this.cloud3d.setHistogram(hist);
            this.annotation = this.saveAnnotation;
            this.title = this.saveTitle;
            this.name = this.saveName;
        } else {
            this.add(this.path, (IManagedObject)hist);
        }
    }

    @Override
    public void end_parameters() throws SAXException {
    }

    @Override
    public void end_profile1d() throws SAXException {
        Profile1D hist = new Profile1D();
        hist.setName(this.name);
        hist.initProfile1D(this.axes[0]);
        hist.setContents(this.heights1d, this.errors1d, this.entries1d, this.rmss1d, this.means1d);
        hist.setMean(this.mean[0]);
        hist.setRms(this.rms[0]);
        if (this.annotation != null) {
            hist.setAnnotation(this.annotation);
            this.annotation = null;
        }
        hist.setTitle(this.title == null ? this.name : this.title);
        this.add(this.path, (IManagedObject)hist);
    }

    @Override
    public void end_profile2d() throws SAXException {
        Profile2D hist = new Profile2D();
        hist.setName(this.name);
        hist.initProfile2D(this.axes[0], this.axes[1]);
        hist.setContents(this.heights2d, this.errors2d, this.entries2d, this.rmssx2d, this.meansx2d, this.meansy2d);
        hist.setMeanX(this.mean[0]);
        hist.setRmsX(this.rms[0]);
        hist.setMeanY(this.mean[1]);
        hist.setRmsY(this.rms[1]);
        if (this.annotation != null) {
            hist.setAnnotation(this.annotation);
            this.annotation = null;
        }
        hist.setTitle(this.title == null ? this.name : this.title);
        this.add(this.path, (IManagedObject)hist);
    }

    @Override
    public void end_row() throws SAXException {
        this.tuple.addRow();
    }

    @Override
    public void end_rows() throws SAXException {
    }

    @Override
    public void end_statistics() throws SAXException {
    }

    @Override
    public void end_tuple() throws SAXException {
        if (this.annotation != null) {
            this.tuple.setAnnotation(this.annotation);
            this.annotation = null;
        }
        this.tuple.setTitle(this.title == null ? this.name : this.title);
        this.add(this.path, (IManagedObject)this.tuple);
    }

    @Override
    public void handle_bin1d(org.xml.sax.Attributes atts) throws SAXException {
        this.handle_bin1d(new AttributesAdapter(atts));
    }

    @Override
    public void handle_bin1d(Attributes meta) throws SAXException {
        int bin = this.getBinNum(meta.getIntValue(27), this.axes[0].bins());
        this.errors1d[bin] = meta.getDoubleValue(31, Double.NaN);
        this.entries1d[bin] = meta.getIntValue(22);
        this.heights1d[bin] = meta.getDoubleValue(30, this.entries1d[bin]);
        if (this.hasBinMeanAndRms) {
            boolean hasWeightedMean = meta.getType(28) >= 0;
            boolean hasWeightedRms = meta.getType(29) >= 0;
            boolean hasRms = meta.getType(25) >= 0;
            boolean bl = this.hasBinMeanAndRms = hasWeightedMean && (hasWeightedRms || hasRms);
            if (this.hasBinMeanAndRms) {
                this.means1d[bin] = meta.getDoubleValue(28);
                this.rmss1d[bin] = meta.getDoubleValue(hasWeightedRms ? 29 : 25);
            }
        }
    }

    @Override
    public void handle_bin2d(org.xml.sax.Attributes atts) throws SAXException {
        this.handle_bin2d(new AttributesAdapter(atts));
    }

    @Override
    public void handle_bin2d(Attributes meta) throws SAXException {
        int xBin = this.getBinNum(meta.getIntValue(33), this.axes[0].bins());
        int yBin = this.getBinNum(meta.getIntValue(34), this.axes[1].bins());
        this.errors2d[xBin][yBin] = meta.getDoubleValue(31, Double.NaN);
        this.entries2d[xBin][yBin] = meta.getIntValue(22);
        this.heights2d[xBin][yBin] = meta.getDoubleValue(30, this.entries2d[xBin][yBin]);
        if (this.hasBinMeanAndRms) {
            boolean hasWeightedMeanX = meta.getType(36) >= 0;
            boolean hasWeightedRmsX = meta.getType(39) >= 0;
            boolean hasRms = meta.getType(25) >= 0;
            boolean hasWeightedMeanY = meta.getType(37) >= 0;
            boolean bl = this.hasBinMeanAndRms = hasWeightedMeanX && hasWeightedMeanY && (hasWeightedRmsX || hasRms);
            if (this.hasBinMeanAndRms) {
                this.meansx2d[xBin][yBin] = meta.getDoubleValue(36);
                this.rmssx2d[xBin][yBin] = meta.getDoubleValue(hasWeightedRmsX ? 39 : 25);
                this.meansy2d[xBin][yBin] = meta.getDoubleValue(37);
                if (meta.getType(40) >= 0) {
                    this.rmssy2d[xBin][yBin] = meta.getDoubleValue(40);
                }
            }
        }
    }

    @Override
    public void handle_bin3d(org.xml.sax.Attributes atts) throws SAXException {
        this.handle_bin3d(new AttributesAdapter(atts));
    }

    @Override
    public void handle_bin3d(Attributes meta) throws SAXException {
        int xBin = this.getBinNum(meta.getIntValue(33), this.axes[0].bins());
        int yBin = this.getBinNum(meta.getIntValue(34), this.axes[1].bins());
        int zBin = this.getBinNum(meta.getIntValue(35), this.axes[2].bins());
        this.errors3d[xBin][yBin][zBin] = meta.getDoubleValue(31, Double.NaN);
        this.entries3d[xBin][yBin][zBin] = meta.getIntValue(22);
        this.heights3d[xBin][yBin][zBin] = meta.getDoubleValue(30, this.entries3d[xBin][yBin][zBin]);
        if (this.hasBinMeanAndRms) {
            boolean hasWeightedMeanX = meta.getType(36) >= 0;
            boolean hasWeightedRmsX = meta.getType(39) >= 0;
            boolean hasWeightedMeanY = meta.getType(37) >= 0;
            boolean hasWeightedRmsY = meta.getType(40) >= 0;
            boolean hasWeightedMeanZ = meta.getType(38) >= 0;
            boolean hasWeightedRmsZ = meta.getType(41) >= 0;
            boolean bl = this.hasBinMeanAndRms = hasWeightedMeanX && hasWeightedMeanY && hasWeightedMeanZ && hasWeightedRmsX && hasWeightedRmsY && hasWeightedRmsZ;
            if (this.hasBinMeanAndRms) {
                this.meansx3d[xBin][yBin][zBin] = meta.getDoubleValue(36);
                this.rmssx3d[xBin][yBin][zBin] = meta.getDoubleValue(39);
                this.meansy3d[xBin][yBin][zBin] = meta.getDoubleValue(37);
                this.rmssy3d[xBin][yBin][zBin] = meta.getDoubleValue(40);
                this.meansz3d[xBin][yBin][zBin] = meta.getDoubleValue(38);
                this.rmssz3d[xBin][yBin][zBin] = meta.getDoubleValue(41);
            }
        }
    }

    @Override
    public void handle_binBorder(org.xml.sax.Attributes atts) throws SAXException {
        this.handle_binBorder(new AttributesAdapter(atts));
    }

    @Override
    public void handle_binBorder(Attributes meta) throws SAXException {
        if (this.binBorders == null) {
            this.binBorders = new double[this.nBins + 1];
            this.binBorders[0] = this.binMin;
            this.binBorders[this.nBins] = this.binMax;
            this.nBin = 1;
        }
        this.binBorders[this.nBin++] = meta.getDoubleValue(7);
    }

    @Override
    public void handle_codelet(String data, org.xml.sax.Attributes atts) throws SAXException {
        this.handle_codelet(data, new AttributesAdapter(atts));
    }

    @Override
    public void handle_codelet(String data, Attributes meta) throws SAXException {
        String codelet = data;
        if (codelet.startsWith("\n")) {
            codelet = codelet.substring(1);
        }
        if (codelet.endsWith("\n")) {
            codelet = codelet.substring(0, codelet.length() - 1);
        }
        codelet = codelet.trim();
        this.function = FunctionCatalog.getFunctionCatalog().getFunctionCreator().createFromCodelet(codelet);
        if (this.title != null) {
            this.function.setTitle(this.title);
        }
    }

    @Override
    public void handle_column(org.xml.sax.Attributes atts) throws SAXException {
        this.handle_column(new AttributesAdapter(atts));
    }

    @Override
    public void handle_column(Attributes meta) throws SAXException {
        String type = meta.getStringValue(42);
        if (!(this.tupleString.equals("") || this.tupleString.endsWith(",") || this.tupleString.endsWith("{"))) {
            this.tupleString = this.tupleString + ",";
        }
        this.tupleString = this.tupleString + type + " " + meta.getStringValue(14);
        if (!this.beforeAida33 && type.equalsIgnoreCase("ITuple")) {
            this.tupleString = this.tupleString + "={";
            ++this.innerFolders;
        }
    }

    @Override
    public void handle_entry(org.xml.sax.Attributes atts) throws SAXException {
        this.handle_entry(new AttributesAdapter(atts));
    }

    @Override
    public void handle_entry(Attributes meta) throws SAXException {
        Class colType = this.tuple.columnType(this.column);
        if (colType == Integer.TYPE) {
            this.tuple.fill(this.column, meta.getIntValue(9));
        } else if (colType == Short.TYPE) {
            this.tuple.fill(this.column, meta.getShortValue(11));
        } else if (colType == Long.TYPE) {
            this.tuple.fill(this.column, meta.getLongValue(10));
        } else if (colType == Float.TYPE) {
            this.tuple.fill(this.column, meta.getFloatValue(8));
        } else if (colType == Double.TYPE) {
            this.tuple.fill(this.column, meta.getDoubleValue(7));
        } else if (colType == Boolean.TYPE) {
            this.tuple.fill(this.column, meta.getBooleanValue(4));
        } else if (colType == Byte.TYPE) {
            this.tuple.fill(this.column, meta.getByteValue(5));
        } else if (colType == Character.TYPE) {
            this.tuple.fill(this.column, meta.getCharValue(6));
        } else if (colType == String.class) {
            this.tuple.fill(this.column, meta.getStringValue(12));
        } else {
            this.tuple.fill(this.column, meta.getStringValue(12));
        }
        ++this.column;
    }

    @Override
    public void handle_entry1d(org.xml.sax.Attributes atts) throws SAXException {
        this.handle_entry1d(new AttributesAdapter(atts));
    }

    @Override
    public void handle_entry1d(Attributes meta) throws SAXException {
        double value = meta.getDoubleValue(62);
        double weight = meta.getDoubleValue(65, 1.0);
        this.cloud1d.fill(value, weight);
    }

    @Override
    public void handle_entry2d(org.xml.sax.Attributes atts) throws SAXException {
        this.handle_entry2d(new AttributesAdapter(atts));
    }

    @Override
    public void handle_entry2d(Attributes meta) throws SAXException {
        double x = meta.getDoubleValue(62);
        double y = meta.getDoubleValue(63);
        double weight = meta.getDoubleValue(65, 1.0);
        this.cloud2d.fill(x, y, weight);
    }

    @Override
    public void handle_entry3d(org.xml.sax.Attributes atts) throws SAXException {
        this.handle_entry3d(new AttributesAdapter(atts));
    }

    @Override
    public void handle_entry3d(Attributes meta) throws SAXException {
        double x = meta.getDoubleValue(62);
        double y = meta.getDoubleValue(63);
        double z = meta.getDoubleValue(64);
        double weight = meta.getDoubleValue(65, 1.0);
        this.cloud3d.fill(x, y, z, weight);
    }

    @Override
    public void handle_implementation(org.xml.sax.Attributes atts) throws SAXException {
        this.handle_implementation(new AttributesAdapter(atts));
    }

    @Override
    public void handle_implementation(Attributes meta) throws SAXException {
    }

    @Override
    public void handle_item(org.xml.sax.Attributes atts) throws SAXException {
        this.handle_item(new AttributesAdapter(atts));
    }

    @Override
    public void handle_item(Attributes meta) throws SAXException {
        String key = meta.getStringValue(69);
        String val = meta.getStringValue(12);
        boolean sticky = meta.getBooleanValue(70, false);
        this.annotation.addItem(key, val, sticky);
    }

    @Override
    public void handle_measurement(org.xml.sax.Attributes atts) throws SAXException {
        this.handle_measurement(new AttributesAdapter(atts));
    }

    @Override
    public void handle_measurement(Attributes meta) throws SAXException {
        IMeasurement m = this.dataPoint.coordinate(this.nextCoord++);
        m.setValue(meta.getDoubleValue(7));
        if (meta.getType(67) >= 0) {
            m.setErrorPlus(meta.getDoubleValue(67));
        }
        if (meta.getType(68) >= 0) {
            m.setErrorMinus(meta.getDoubleValue(68));
        }
    }

    @Override
    public void handle_parameter(org.xml.sax.Attributes atts) throws SAXException {
        this.handle_parameter(new AttributesAdapter(atts));
    }

    @Override
    public void handle_parameter(Attributes meta) throws SAXException {
        String parName = meta.getStringValue(14);
        this.function.setParameter(parName, meta.getDoubleValue(7));
    }

    @Override
    public void handle_range(org.xml.sax.Attributes atts) throws SAXException {
        this.handle_range(new AttributesAdapter(atts));
    }

    @Override
    public void handle_range(Attributes meta) throws SAXException {
        if (this.function instanceof IModelFunction) {
            IModelFunction model = (IModelFunction)this.function;
            int argIndex = -1;
            for (int i = 0; i < model.dimension(); ++i) {
                if (!model.variableName(i).equals(this.argName)) continue;
                argIndex = i;
                break;
            }
            double min = meta.getDoubleValue(19);
            double max = meta.getDoubleValue(20);
            model.normalizationRange(argIndex).include(min, max);
        }
    }

    @Override
    public void handle_statistic(org.xml.sax.Attributes atts) throws SAXException {
        this.handle_statistic(new AttributesAdapter(atts));
    }

    @Override
    public void handle_statistic(Attributes meta) throws SAXException {
        int dir = this.directionToInt(meta.getStringValue(18, "x"));
        this.mean[dir] = meta.getDoubleValue(24);
        this.rms[dir] = meta.getDoubleValue(25);
    }

    @Override
    public void start_aida(org.xml.sax.Attributes atts) throws SAXException {
        this.start_aida(new AttributesAdapter(atts));
    }

    @Override
    public void start_aida(Attributes meta) throws SAXException {
        this.aidaVersion = meta.getStringValue(0);
        this.aida22 = this.aidaVersion.startsWith("2.2");
        StringTokenizer st = new StringTokenizer(this.aidaVersion, ".");
        int nTokens = st.countTokens();
        if (nTokens > 3) {
            throw new RuntimeException("Illegal version for parsing.");
        }
        int majorVersion = Integer.parseInt(st.nextToken());
        int revisionVersion = Integer.parseInt(st.nextToken());
        boolean patchVersion = false;
        if (nTokens == 3) {
            Integer.parseInt(st.nextToken());
        }
        this.beforeAida33 = majorVersion < 3 || majorVersion == 3 && revisionVersion <= 2;
    }

    @Override
    public void start_annotation(org.xml.sax.Attributes atts) throws SAXException {
        this.start_annotation(new AttributesAdapter(atts));
    }

    @Override
    public void start_annotation(Attributes meta) throws SAXException {
        this.annotation = new Annotation();
    }

    @Override
    public void start_argument(org.xml.sax.Attributes atts) throws SAXException {
        this.start_argument(new AttributesAdapter(atts));
    }

    @Override
    public void start_argument(Attributes meta) throws SAXException {
        this.argName = meta.getStringValue(14);
    }

    @Override
    public void start_arguments(org.xml.sax.Attributes atts) throws SAXException {
        this.start_arguments(new AttributesAdapter(atts));
    }

    @Override
    public void start_arguments(Attributes meta) throws SAXException {
    }

    @Override
    public void start_axis(org.xml.sax.Attributes atts) throws SAXException {
        this.start_axis(new AttributesAdapter(atts));
    }

    @Override
    public void start_axis(Attributes meta) throws SAXException {
        this.binMin = meta.getDoubleValue(19);
        this.binMax = meta.getDoubleValue(20);
        this.nBins = meta.getIntValue(21);
        this.nAxis = this.directionToInt(meta.getStringValue(18, "x"));
        this.binBorders = null;
    }

    @Override
    public void start_cloud1d(org.xml.sax.Attributes atts) throws SAXException {
        this.start_cloud1d(new AttributesAdapter(atts));
    }

    @Override
    public void start_cloud1d(Attributes meta) throws SAXException {
        int conversionBins;
        this.start_managedObject(meta);
        this.cloud1d = new Cloud1D();
        this.cloud1d.initCloud(meta.getIntValue(43), this.options);
        this.cloud1d.setName(this.name);
        double uE = meta.getDoubleValue(47, Double.NaN);
        double lE = meta.getDoubleValue(44, Double.NaN);
        if (!Double.isNaN(uE)) {
            this.cloud1d.setUpperEdge(uE);
        }
        if (!Double.isNaN(lE)) {
            this.cloud1d.setLowerEdge(lE);
        }
        if ((conversionBins = meta.getIntValue(50, -1)) >= 0) {
            double le = meta.getDoubleValue(54, Double.NaN);
            double ue = meta.getDoubleValue(58, Double.NaN);
            this.cloud1d.setConversionParameters(conversionBins, le, ue);
        }
    }

    @Override
    public void start_cloud2d(org.xml.sax.Attributes atts) throws SAXException {
        this.start_cloud2d(new AttributesAdapter(atts));
    }

    @Override
    public void start_cloud2d(Attributes meta) throws SAXException {
        this.start_managedObject(meta);
        this.cloud2d = new Cloud2D();
        this.cloud2d.initCloud(meta.getIntValue(43), this.options);
        this.cloud2d.setName(this.name);
        double uE = meta.getDoubleValue(47, Double.NaN);
        double lE = meta.getDoubleValue(44, Double.NaN);
        if (!Double.isNaN(uE)) {
            this.cloud2d.setUpperEdgeX(uE);
        }
        if (!Double.isNaN(lE)) {
            this.cloud2d.setLowerEdgeX(lE);
        }
        uE = meta.getDoubleValue(48, Double.NaN);
        lE = meta.getDoubleValue(45, Double.NaN);
        if (!Double.isNaN(uE)) {
            this.cloud2d.setUpperEdgeY(uE);
        }
        if (!Double.isNaN(lE)) {
            this.cloud2d.setLowerEdgeY(lE);
        }
        int conversionBinsX = meta.getIntValue(51, -1);
        int conversionBinsY = meta.getIntValue(52, -1);
        if (conversionBinsX >= 0 && conversionBinsY >= 0) {
            double lex = meta.getDoubleValue(55, Double.NaN);
            double uex = meta.getDoubleValue(59, Double.NaN);
            double ley = meta.getDoubleValue(56, Double.NaN);
            double uey = meta.getDoubleValue(60, Double.NaN);
            this.cloud2d.setConversionParameters(conversionBinsX, lex, uex, conversionBinsY, ley, uey);
        }
    }

    @Override
    public void start_cloud3d(org.xml.sax.Attributes atts) throws SAXException {
        this.start_cloud3d(new AttributesAdapter(atts));
    }

    @Override
    public void start_cloud3d(Attributes meta) throws SAXException {
        this.start_managedObject(meta);
        this.cloud3d = new Cloud3D();
        this.cloud3d.initCloud(meta.getIntValue(43), this.options);
        this.cloud3d.setName(this.name);
        double uE = meta.getDoubleValue(47, Double.NaN);
        double lE = meta.getDoubleValue(44, Double.NaN);
        if (!Double.isNaN(uE)) {
            this.cloud3d.setUpperEdgeX(uE);
        }
        if (!Double.isNaN(lE)) {
            this.cloud3d.setLowerEdgeX(lE);
        }
        uE = meta.getDoubleValue(48, Double.NaN);
        lE = meta.getDoubleValue(45, Double.NaN);
        if (!Double.isNaN(uE)) {
            this.cloud3d.setUpperEdgeY(uE);
        }
        if (!Double.isNaN(lE)) {
            this.cloud3d.setLowerEdgeY(lE);
        }
        uE = meta.getDoubleValue(49, Double.NaN);
        lE = meta.getDoubleValue(46, Double.NaN);
        if (!Double.isNaN(uE)) {
            this.cloud3d.setUpperEdgeZ(uE);
        }
        if (!Double.isNaN(lE)) {
            this.cloud3d.setLowerEdgeZ(lE);
        }
        int conversionBinsX = meta.getIntValue(51, -1);
        int conversionBinsY = meta.getIntValue(52, -1);
        int conversionBinsZ = meta.getIntValue(53, -1);
        if (conversionBinsX >= 0 && conversionBinsY >= 0 && conversionBinsZ >= 0) {
            double lex = meta.getDoubleValue(55, Double.NaN);
            double uex = meta.getDoubleValue(59, Double.NaN);
            double ley = meta.getDoubleValue(56, Double.NaN);
            double uey = meta.getDoubleValue(60, Double.NaN);
            double lez = meta.getDoubleValue(57, Double.NaN);
            double uez = meta.getDoubleValue(61, Double.NaN);
            this.cloud3d.setConversionParameters(conversionBinsX, lex, uex, conversionBinsY, ley, uey, conversionBinsZ, lez, uez);
        }
    }

    @Override
    public void start_columns(org.xml.sax.Attributes atts) throws SAXException {
        this.start_columns(new AttributesAdapter(atts));
    }

    @Override
    public void start_columns(Attributes meta) throws SAXException {
    }

    @Override
    public void start_data1d(org.xml.sax.Attributes atts) throws SAXException {
        this.start_data1d(new AttributesAdapter(atts));
    }

    @Override
    public void start_data1d(Attributes meta) throws SAXException {
        int xBins = this.axes[0].bins() + 2;
        this.heights1d = new double[xBins];
        this.errors1d = new double[xBins];
        this.entries1d = new int[xBins];
        this.means1d = new double[xBins];
        this.rmss1d = new double[xBins];
        this.hasBinMeanAndRms = true;
    }

    @Override
    public void start_data2d(org.xml.sax.Attributes atts) throws SAXException {
        this.start_data2d(new AttributesAdapter(atts));
    }

    @Override
    public void start_data2d(Attributes meta) throws SAXException {
        int xBins = this.axes[0].bins() + 2;
        int yBins = this.axes[1].bins() + 2;
        this.heights2d = new double[xBins][yBins];
        this.errors2d = new double[xBins][yBins];
        this.entries2d = new int[xBins][yBins];
        this.meansx2d = new double[xBins][yBins];
        this.rmssx2d = new double[xBins][yBins];
        this.meansy2d = new double[xBins][yBins];
        this.rmssy2d = new double[xBins][yBins];
        this.hasBinMeanAndRms = true;
    }

    @Override
    public void start_data3d(org.xml.sax.Attributes atts) throws SAXException {
        this.start_data3d(new AttributesAdapter(atts));
    }

    @Override
    public void start_data3d(Attributes meta) throws SAXException {
        int xBins = this.axes[0].bins() + 2;
        int yBins = this.axes[1].bins() + 2;
        int zBins = this.axes[2].bins() + 2;
        this.heights3d = new double[xBins][yBins][zBins];
        this.errors3d = new double[xBins][yBins][zBins];
        this.entries3d = new int[xBins][yBins][zBins];
        this.meansx3d = new double[xBins][yBins][zBins];
        this.rmssx3d = new double[xBins][yBins][zBins];
        this.meansy3d = new double[xBins][yBins][zBins];
        this.rmssy3d = new double[xBins][yBins][zBins];
        this.meansz3d = new double[xBins][yBins][zBins];
        this.rmssz3d = new double[xBins][yBins][zBins];
        this.hasBinMeanAndRms = true;
    }

    @Override
    public void start_dataPoint(org.xml.sax.Attributes atts) throws SAXException {
        this.start_dataPoint(new AttributesAdapter(atts));
    }

    @Override
    public void start_dataPoint(Attributes meta) throws SAXException {
        this.dataPointSet.addPoint();
        this.dataPoint = this.dataPointSet.point(this.dataPointSet.size() - 1);
        this.nextCoord = 0;
    }

    @Override
    public void start_dataPointSet(org.xml.sax.Attributes atts) throws SAXException {
        this.start_dataPointSet(new AttributesAdapter(atts));
    }

    @Override
    public void start_dataPointSet(Attributes meta) throws SAXException {
        this.start_managedObject(meta);
        int dim = meta.getIntValue(66);
        this.dataPointSet = new DataPointSet(this.name, this.title, dim);
    }

    @Override
    public void start_entries1d(org.xml.sax.Attributes atts) throws SAXException {
        this.start_entries1d(new AttributesAdapter(atts));
    }

    @Override
    public void start_entries1d(Attributes meta) throws SAXException {
    }

    @Override
    public void start_entries2d(org.xml.sax.Attributes atts) throws SAXException {
        this.start_entries2d(new AttributesAdapter(atts));
    }

    @Override
    public void start_entries2d(Attributes meta) throws SAXException {
    }

    @Override
    public void start_entries3d(org.xml.sax.Attributes atts) throws SAXException {
        this.start_entries3d(new AttributesAdapter(atts));
    }

    @Override
    public void start_entries3d(Attributes meta) throws SAXException {
    }

    @Override
    public void start_entryITuple(org.xml.sax.Attributes atts) throws SAXException {
        this.start_entryITuple(new AttributesAdapter(atts));
    }

    @Override
    public void start_entryITuple(Attributes meta) throws SAXException {
        this.stack.push(new Object[]{this.tuple, new Integer(this.column)});
        this.tuple = (Tuple)this.tuple.getObject(this.column);
        this.column = 0;
    }

    @Override
    public void start_function(org.xml.sax.Attributes atts) throws SAXException {
        this.start_function(new AttributesAdapter(atts));
    }

    @Override
    public void start_function(Attributes meta) throws SAXException {
        this.start_managedObject(meta);
        this.isNormalized = meta.getBooleanValue(71);
    }

    @Override
    public void start_histogram1d(org.xml.sax.Attributes atts) throws SAXException {
        this.start_histogram1d(new AttributesAdapter(atts));
    }

    @Override
    public void start_histogram1d(Attributes meta) throws SAXException {
        if (this.cloud1d != null) {
            this.saveAnnotation = this.annotation;
            this.saveTitle = this.title;
            this.saveName = this.name;
        }
        this.start_managedObject(meta);
    }

    @Override
    public void start_histogram2d(org.xml.sax.Attributes atts) throws SAXException {
        this.start_histogram2d(new AttributesAdapter(atts));
    }

    @Override
    public void start_histogram2d(Attributes meta) throws SAXException {
        if (this.cloud2d != null) {
            this.saveAnnotation = this.annotation;
            this.saveTitle = this.title;
            this.saveName = this.name;
        }
        this.start_managedObject(meta);
    }

    @Override
    public void start_histogram3d(org.xml.sax.Attributes atts) throws SAXException {
        this.start_histogram3d(new AttributesAdapter(atts));
    }

    @Override
    public void start_histogram3d(Attributes meta) throws SAXException {
        if (this.cloud3d != null) {
            this.saveAnnotation = this.annotation;
            this.saveTitle = this.title;
            this.saveName = this.name;
        }
        this.start_managedObject(meta);
    }

    @Override
    public void start_parameters(org.xml.sax.Attributes atts) throws SAXException {
        this.start_parameters(new AttributesAdapter(atts));
    }

    @Override
    public void start_parameters(Attributes meta) throws SAXException {
    }

    @Override
    public void start_profile1d(org.xml.sax.Attributes atts) throws SAXException {
        this.start_profile1d(new AttributesAdapter(atts));
    }

    @Override
    public void start_profile1d(Attributes meta) throws SAXException {
        this.start_managedObject(meta);
    }

    @Override
    public void start_profile2d(org.xml.sax.Attributes atts) throws SAXException {
        this.start_profile2d(new AttributesAdapter(atts));
    }

    @Override
    public void start_profile2d(Attributes meta) throws SAXException {
        this.start_managedObject(meta);
    }

    @Override
    public void start_row(org.xml.sax.Attributes atts) throws SAXException {
        this.start_row(new AttributesAdapter(atts));
    }

    @Override
    public void start_row(Attributes meta) throws SAXException {
        this.column = 0;
    }

    @Override
    public void start_rows(org.xml.sax.Attributes atts) throws SAXException {
        this.start_rows(new AttributesAdapter(atts));
    }

    @Override
    public void start_rows(Attributes meta) throws SAXException {
        if (this.tupleString.endsWith(",")) {
            this.tupleString = this.tupleString.substring(0, this.tupleString.length() - 1);
        }
        this.tuple = new Tuple(this.name, this.title, this.tupleString, this.options);
    }

    @Override
    public void start_statistics(org.xml.sax.Attributes atts) throws SAXException {
        this.start_statistics(new AttributesAdapter(atts));
    }

    @Override
    public void start_statistics(Attributes meta) throws SAXException {
    }

    @Override
    public void start_tuple(org.xml.sax.Attributes atts) throws SAXException {
        this.start_tuple(new AttributesAdapter(atts));
    }

    @Override
    public void start_tuple(Attributes meta) throws SAXException {
        this.start_managedObject(meta);
        this.tupleString = "";
    }

    private void add(String path, IManagedObject obj) {
        if (path == null) {
            path = "/";
            if (this.markAsFilled) {
                this.tree.hasBeenFilled("/");
            }
        } else {
            this.tree.mkdirs(path);
            StringTokenizer st = new StringTokenizer(path, "/");
            String currentpath = "/";
            if (st.countTokens() > 0) {
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    currentpath = currentpath + token + "/";
                    if (!this.markAsFilled) continue;
                    this.tree.hasBeenFilled(currentpath);
                    if (!(obj instanceof Folder)) continue;
                    this.tree.hasBeenFilled(currentpath + obj.name());
                }
            }
        }
        this.tree.add(path, obj);
    }

    private int getBinNum(int bin, int nBins) {
        switch (bin) {
            case -2: {
                return 0;
            }
            case -1: {
                return nBins + 1;
            }
        }
        return bin + 1;
    }

    public void start_managedObject(org.xml.sax.Attributes atts) throws SAXException {
        this.start_managedObject(new AttributesAdapter(atts));
    }

    private void start_managedObject(Attributes meta) throws SAXException {
        this.name = meta.getStringValue(14);
        this.title = meta.getStringValue(this.aida22 ? 72 : 15);
        this.path = meta.getStringValue(16);
        this.options = meta.getStringValue(17);
    }

    private int directionToInt(String direction) {
        if (direction.equals("x")) {
            return 0;
        }
        if (direction.equals("y")) {
            return 1;
        }
        if (direction.equals("z")) {
            return 2;
        }
        return 0;
    }

    private class AttributesAdapter
    implements Attributes {
        private org.xml.sax.Attributes atts;

        public AttributesAdapter(org.xml.sax.Attributes atts) {
            this.atts = atts;
        }

        @Override
        public int[] getTags() {
            int[] tags = new int[this.atts.getLength()];
            for (int i = 0; i < tags.length; ++i) {
                tags[i] = AidaWBXMLLookup.getAttribute(this.atts.getQName(i));
            }
            return tags;
        }

        @Override
        public int getType(int tag) {
            return this.atts.getValue(this.getAttributeName(tag)) == null ? -1 : AidaWBXMLLookup.getAttributeType(tag);
        }

        private String getAttributeName(int tag) {
            switch (tag) {
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    return "value";
                }
            }
            return AidaWBXMLLookup.getAttributeName(tag);
        }

        @Override
        public String getStringValue(int tag, String def) {
            String val = this.atts.getValue(this.getAttributeName(tag));
            return val != null ? val : def;
        }

        @Override
        public double getDoubleValue(int tag, double def) {
            String val = this.atts.getValue(this.getAttributeName(tag));
            return val != null ? AidaWBXMLConverter.toDouble(-1, tag, val) : def;
        }

        @Override
        public float getFloatValue(int tag, float def) {
            return (float)this.getDoubleValue(tag, def);
        }

        @Override
        public long getLongValue(int tag, long def) {
            String val = this.atts.getValue(this.getAttributeName(tag));
            return val != null ? Long.parseLong(val) : def;
        }

        @Override
        public int getIntValue(int tag, int def) {
            String val = this.atts.getValue(this.getAttributeName(tag));
            return val != null ? AidaWBXMLConverter.toInt(-1, tag, val) : def;
        }

        @Override
        public short getShortValue(int tag, short def) {
            String val = this.atts.getValue(this.getAttributeName(tag));
            return val != null ? Short.parseShort(val) : def;
        }

        @Override
        public char getCharValue(int tag, char def) {
            String val = this.atts.getValue(this.getAttributeName(tag));
            return val != null ? val.charAt(0) : def;
        }

        @Override
        public byte getByteValue(int tag, byte def) {
            String val = this.atts.getValue(this.getAttributeName(tag));
            return val != null ? Byte.parseByte(val) : def;
        }

        @Override
        public boolean getBooleanValue(int tag, boolean def) {
            String val = this.atts.getValue(this.getAttributeName(tag));
            return val != null ? AidaWBXMLConverter.toBoolean(-1, tag, val) : def;
        }

        @Override
        public boolean getBooleanValue(int tag) {
            return AidaWBXMLConverter.toBoolean(-1, tag, this.atts.getValue(this.getAttributeName(tag)));
        }

        @Override
        public boolean[] getBooleanArray(int tag) {
            throw new NumberFormatException();
        }

        @Override
        public byte getByteValue(int tag) {
            return Byte.parseByte(this.atts.getValue(this.getAttributeName(tag)));
        }

        @Override
        public byte[] getByteArray(int tag) {
            throw new NumberFormatException();
        }

        @Override
        public char getCharValue(int tag) {
            return this.atts.getValue(this.getAttributeName(tag)).charAt(0);
        }

        @Override
        public char[] getCharArray(int tag) {
            throw new NumberFormatException();
        }

        @Override
        public double getDoubleValue(int tag) {
            return AidaWBXMLConverter.toDouble(-1, tag, this.atts.getValue(this.getAttributeName(tag)));
        }

        @Override
        public double[] getDoubleArray(int tag) {
            throw new NumberFormatException();
        }

        @Override
        public float getFloatValue(int tag) {
            return (float)this.getDoubleValue(tag);
        }

        @Override
        public float[] getFloatArray(int tag) {
            throw new NumberFormatException();
        }

        @Override
        public int getIntValue(int tag) {
            return AidaWBXMLConverter.toInt(-1, tag, this.atts.getValue(this.getAttributeName(tag)));
        }

        @Override
        public int[] getIntArray(int tag) {
            throw new NumberFormatException();
        }

        @Override
        public long getLongValue(int tag) {
            return Long.parseLong(this.atts.getValue(this.getAttributeName(tag)));
        }

        @Override
        public long[] getLongArray(int tag) {
            throw new NumberFormatException();
        }

        @Override
        public short getShortValue(int tag) {
            return Short.parseShort(this.atts.getValue(this.getAttributeName(tag)));
        }

        @Override
        public short[] getShortArray(int tag) {
            throw new NumberFormatException();
        }

        @Override
        public String getStringValue(int tag) {
            return this.atts.getValue(this.getAttributeName(tag));
        }

        @Override
        public String[] getStringArray(int tag) {
            throw new NumberFormatException();
        }
    }
}

