/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.root;

import hep.aida.ITuple;
import hep.aida.ref.root.TLeafBColumn;
import hep.aida.ref.root.TLeafColumn;
import hep.aida.ref.root.TLeafDColumn;
import hep.aida.ref.root.TLeafFColumn;
import hep.aida.ref.root.TLeafIColumn;
import hep.aida.ref.root.TLeafLColumn;
import hep.aida.ref.tuple.ReadOnlyAbstractTuple;
import hep.io.root.interfaces.TLeaf;
import hep.io.root.interfaces.TLeafB;
import hep.io.root.interfaces.TLeafD;
import hep.io.root.interfaces.TLeafF;
import hep.io.root.interfaces.TLeafI;
import hep.io.root.interfaces.TLeafL;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.freehep.util.Value;

class TLeafFolderColumn
extends TLeafColumn {
    private TLeafI dim;
    private TLeafColumn[] columns;
    private EmbeddedTuple embedded;

    TLeafFolderColumn(TLeafI dim) {
        this.dim = dim;
        this.embedded = new EmbeddedTuple(this.name());
    }

    void addColumn(TLeaf leaf) {
        TLeafColumn col;
        if (leaf instanceof TLeafI) {
            col = new TLeafIColumn((TLeafI)leaf);
        } else if (leaf instanceof TLeafL) {
            col = new TLeafLColumn((TLeafL)leaf);
        } else if (leaf instanceof TLeafF) {
            col = new TLeafFColumn((TLeafF)leaf);
        } else if (leaf instanceof TLeafD) {
            col = new TLeafDColumn((TLeafD)leaf);
        } else if (leaf instanceof TLeafB) {
            col = new TLeafBColumn((TLeafB)leaf);
        } else {
            System.out.println("Ignored column " + leaf.getName() + " of type " + leaf.getClass());
            return;
        }
        if (this.columns == null) {
            this.columns = new TLeafColumn[]{col};
        } else {
            ArrayList<TLeafColumn> x = new ArrayList<TLeafColumn>(Arrays.asList(this.columns));
            x.add(col);
            this.columns = new TLeafColumn[x.size()];
            x.toArray(this.columns);
        }
    }

    @Override
    void getValue(int row, Value value) {
        try {
            this.embedded.setGlobalRow(row);
            value.set(this.embedded);
        }
        catch (IOException x) {
            throw new RuntimeException("IOException accessing tuple", x);
        }
    }

    @Override
    public void defaultValue(Value value) {
        value.set((Object)null);
    }

    @Override
    public String name() {
        return "Folder[" + this.dim.getName() + "]";
    }

    @Override
    public Class type() {
        return EmbeddedTuple.class;
    }

    @Override
    void getArrayValue(int row, int dim, Value value) {
        throw new UnsupportedOperationException();
    }

    private class EmbeddedTuple
    extends ReadOnlyAbstractTuple {
        private Value theValue;
        private int nRows;
        private int theRow;

        EmbeddedTuple(String name) {
            super(name, "");
            this.theValue = new Value();
        }

        void setGlobalRow(int row) throws IOException {
            this.theRow = row;
            this.nRows = TLeafFolderColumn.this.dim.getValue((long)row);
        }

        @Override
        public boolean providesColumnDefaultValues() {
            return false;
        }

        @Override
        public void columnValue(int column, Value v) {
            TLeafFolderColumn.this.columns[column].getArrayValue(this.theRow, this.getRow(), v);
        }

        @Override
        public boolean isInMemory() {
            return false;
        }

        @Override
        public ITuple findTuple(int param) {
            return null;
        }

        @Override
        public int findColumn(String name) throws IllegalArgumentException {
            for (int i = 0; i < TLeafFolderColumn.this.columns.length; ++i) {
                if (!TLeafFolderColumn.this.columns[i].name().equals(name)) continue;
                return i;
            }
            throw new IllegalArgumentException("Unknown column " + name);
        }

        @Override
        public double columnMax(int index) throws IllegalArgumentException {
            TLeafFolderColumn.this.columns[index].maxValue(this.theValue);
            return this.theValue.getDouble();
        }

        @Override
        public double columnMean(int index) throws IllegalArgumentException {
            TLeafFolderColumn.this.columns[index].meanValue(this.theValue);
            return this.theValue.getDouble();
        }

        @Override
        public double columnMin(int index) throws IllegalArgumentException {
            TLeafFolderColumn.this.columns[index].minValue(this.theValue);
            return this.theValue.getDouble();
        }

        @Override
        public String columnName(int index) throws IllegalArgumentException {
            return TLeafFolderColumn.this.columns[index].name();
        }

        @Override
        public double columnRms(int index) throws IllegalArgumentException {
            TLeafFolderColumn.this.columns[index].rmsValue(this.theValue);
            return this.theValue.getDouble();
        }

        @Override
        public Class columnType(int index) throws IllegalArgumentException {
            return TLeafFolderColumn.this.columns[index].type();
        }

        @Override
        public int columns() {
            return TLeafFolderColumn.this.columns.length;
        }

        @Override
        public int rows() {
            return this.nRows;
        }

        @Override
        public String columnDefaultString(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object columnDefaultValue(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean supportsMultipleCursors() {
            return true;
        }

        @Override
        public boolean supportsRandomAccess() {
            return true;
        }
    }
}

