/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.remote.rmi.server;

import hep.aida.IManagedObject;
import hep.aida.ref.remote.interfaces.AidaTreeClient;
import hep.aida.ref.remote.interfaces.AidaTreeServant;
import hep.aida.ref.remote.interfaces.AidaUpdateEvent;
import hep.aida.ref.remote.rmi.converters.RmiConverter;
import hep.aida.ref.remote.rmi.interfaces.RmiClient;
import hep.aida.ref.remote.rmi.interfaces.RmiServant;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Map;
import java.util.logging.Logger;
import org.freehep.util.FreeHEPLookup;
import org.openide.util.Lookup;

public class RmiServantImpl
extends UnicastRemoteObject
implements RmiServant,
AidaTreeClient {
    static final long serialVersionUID = 5141620123191080485L;
    private Logger remoteLogger = Logger.getLogger("hep.aida.ref.remote");
    private RmiClient rmiClient;
    private AidaTreeServant aidaServant;
    private Map converters;
    private boolean useValidation;

    public RmiServantImpl() throws RemoteException {
        this(null, null);
    }

    public RmiServantImpl(RmiClient rmiClient) throws RemoteException {
        this(rmiClient, null);
    }

    public RmiServantImpl(AidaTreeServant aidaServant) throws RemoteException {
        this(null, aidaServant);
    }

    public RmiServantImpl(RmiClient rmiClient, AidaTreeServant aidaServant) throws RemoteException {
        this.rmiClient = rmiClient;
        this.aidaServant = aidaServant;
        this.useValidation = true;
        this.converters = new Hashtable();
        this.connect();
    }

    public synchronized void setUseValidation(boolean state) {
        this.useValidation = state;
    }

    void connect() {
    }

    void setAidaTreeServant(AidaTreeServant aidaServant) {
        this.aidaServant = aidaServant;
    }

    void setRmiClient(RmiClient rmiClient) {
        this.rmiClient = rmiClient;
    }

    void disconnect() {
        try {
            RmiServantImpl.unexportObject(this, true);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.rmiClient = null;
        this.aidaServant = null;
    }

    protected RmiConverter findConverter(String aidaType) {
        RmiConverter converter = null;
        if (this.converters.containsKey(aidaType)) {
            converter = (RmiConverter)this.converters.get(aidaType);
        } else {
            Lookup.Template template = new Lookup.Template(RmiConverter.class, aidaType, null);
            Lookup.Item item = FreeHEPLookup.instance().lookupItem(template);
            if (item == null) {
                throw new IllegalArgumentException("No Converter for AIDA Type: " + aidaType);
            }
            converter = (RmiConverter)item.getInstance();
            this.converters.put(aidaType, converter);
        }
        return converter;
    }

    @Override
    public Object find(String path) throws RemoteException {
        this.remoteLogger.finest("RmiServantImpl.find for path=" + path);
        Object mo = this.aidaServant.find(path);
        String aidaType = null;
        aidaType = mo instanceof IManagedObject ? ((IManagedObject)mo).type() : mo.getClass().getName();
        this.remoteLogger.finest("RmiServantImpl.find for path=" + path + ", mo=" + mo);
        RmiConverter converter = this.findConverter(aidaType);
        Object data = converter.extractData(mo);
        if (!this.useValidation) {
            this.aidaServant.setValid(new String[]{path});
        }
        this.remoteLogger.finest("RmiServantImpl.find for path=" + path + ", data=" + data);
        return data;
    }

    @Override
    public String[] listObjectNames(String path, boolean recursive) throws RemoteException {
        return this.aidaServant.listObjectNames(path, recursive);
    }

    @Override
    public String[] listObjectTypes(String path, boolean recursive) throws RemoteException {
        return this.aidaServant.listObjectTypes(path, recursive);
    }

    @Override
    public void setValid(String[] nodePaths) throws RemoteException {
        this.remoteLogger.finest("RmiServantImpl.setValid for path=" + nodePaths[0]);
        this.aidaServant.setValid(nodePaths);
        this.remoteLogger.finest("RmiServantImpl.setValid AFTER for path=" + nodePaths[0]);
    }

    @Override
    public AidaUpdateEvent[] updates() throws RemoteException {
        this.remoteLogger.finest("RmiServantImpl.updates");
        AidaUpdateEvent[] result = this.aidaServant.updates();
        this.remoteLogger.finest("RmiServantImpl.updates AFTER, gotEvents=" + result.length);
        return result;
    }

    @Override
    public void stateChanged(AidaUpdateEvent[] events) {
        try {
            this.rmiClient.stateChanged(events);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }
}

